// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The subscription status. </summary>
    public readonly partial struct BillingSubscriptionStatus : IEquatable<BillingSubscriptionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingSubscriptionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingSubscriptionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string UnknownValue = "Unknown";
        private const string ActiveValue = "Active";
        private const string DisabledValue = "Disabled";
        private const string DeletedValue = "Deleted";
        private const string WarnedValue = "Warned";
        private const string ExpiringValue = "Expiring";
        private const string ExpiredValue = "Expired";
        private const string AutoRenewValue = "AutoRenew";
        private const string CancelledValue = "Cancelled";
        private const string SuspendedValue = "Suspended";
        private const string FailedValue = "Failed";

        /// <summary> Other. </summary>
        public static BillingSubscriptionStatus Other { get; } = new BillingSubscriptionStatus(OtherValue);
        /// <summary> Unknown. </summary>
        public static BillingSubscriptionStatus Unknown { get; } = new BillingSubscriptionStatus(UnknownValue);
        /// <summary> Active. </summary>
        public static BillingSubscriptionStatus Active { get; } = new BillingSubscriptionStatus(ActiveValue);
        /// <summary> Disabled. </summary>
        public static BillingSubscriptionStatus Disabled { get; } = new BillingSubscriptionStatus(DisabledValue);
        /// <summary> Deleted. </summary>
        public static BillingSubscriptionStatus Deleted { get; } = new BillingSubscriptionStatus(DeletedValue);
        /// <summary> Warned. </summary>
        public static BillingSubscriptionStatus Warned { get; } = new BillingSubscriptionStatus(WarnedValue);
        /// <summary> Expiring. </summary>
        public static BillingSubscriptionStatus Expiring { get; } = new BillingSubscriptionStatus(ExpiringValue);
        /// <summary> Expired. </summary>
        public static BillingSubscriptionStatus Expired { get; } = new BillingSubscriptionStatus(ExpiredValue);
        /// <summary> AutoRenew. </summary>
        public static BillingSubscriptionStatus AutoRenew { get; } = new BillingSubscriptionStatus(AutoRenewValue);
        /// <summary> Cancelled. </summary>
        public static BillingSubscriptionStatus Cancelled { get; } = new BillingSubscriptionStatus(CancelledValue);
        /// <summary> Suspended. </summary>
        public static BillingSubscriptionStatus Suspended { get; } = new BillingSubscriptionStatus(SuspendedValue);
        /// <summary> Failed. </summary>
        public static BillingSubscriptionStatus Failed { get; } = new BillingSubscriptionStatus(FailedValue);
        /// <summary> Determines if two <see cref="BillingSubscriptionStatus"/> values are the same. </summary>
        public static bool operator ==(BillingSubscriptionStatus left, BillingSubscriptionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingSubscriptionStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingSubscriptionStatus left, BillingSubscriptionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingSubscriptionStatus"/>. </summary>
        public static implicit operator BillingSubscriptionStatus(string value) => new BillingSubscriptionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingSubscriptionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingSubscriptionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
