// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The status of an operation on the subscription. When None, there is no ongoing operation. When LockedForUpdate, write operations will be blocked on the Billing Subscription. Other is the default value and you may need to refer to the latest API version for more details. </summary>
    public readonly partial struct BillingSubscriptionOperationStatus : IEquatable<BillingSubscriptionOperationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingSubscriptionOperationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingSubscriptionOperationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string NoneValue = "None";
        private const string LockedForUpdateValue = "LockedForUpdate";

        /// <summary> Other. </summary>
        public static BillingSubscriptionOperationStatus Other { get; } = new BillingSubscriptionOperationStatus(OtherValue);
        /// <summary> None. </summary>
        public static BillingSubscriptionOperationStatus None { get; } = new BillingSubscriptionOperationStatus(NoneValue);
        /// <summary> LockedForUpdate. </summary>
        public static BillingSubscriptionOperationStatus LockedForUpdate { get; } = new BillingSubscriptionOperationStatus(LockedForUpdateValue);
        /// <summary> Determines if two <see cref="BillingSubscriptionOperationStatus"/> values are the same. </summary>
        public static bool operator ==(BillingSubscriptionOperationStatus left, BillingSubscriptionOperationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingSubscriptionOperationStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingSubscriptionOperationStatus left, BillingSubscriptionOperationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingSubscriptionOperationStatus"/>. </summary>
        public static implicit operator BillingSubscriptionOperationStatus(string value) => new BillingSubscriptionOperationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingSubscriptionOperationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingSubscriptionOperationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
