// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Request parameters to transfer billing subscription. </summary>
    public partial class BillingSubscriptionMoveContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingSubscriptionMoveContent"/>. </summary>
        public BillingSubscriptionMoveContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingSubscriptionMoveContent"/>. </summary>
        /// <param name="destinationInvoiceSectionId"> The destination invoice section id. </param>
        /// <param name="destinationEnrollmentAccountId"> The destination enrollment account id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingSubscriptionMoveContent(ResourceIdentifier destinationInvoiceSectionId, string destinationEnrollmentAccountId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DestinationInvoiceSectionId = destinationInvoiceSectionId;
            DestinationEnrollmentAccountId = destinationEnrollmentAccountId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The destination invoice section id. </summary>
        [WirePath("destinationInvoiceSectionId")]
        public ResourceIdentifier DestinationInvoiceSectionId { get; set; }
        /// <summary> The destination enrollment account id. </summary>
        [WirePath("destinationEnrollmentAccountId")]
        public string DestinationEnrollmentAccountId { get; set; }
    }
}
