// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Request parameters that are provided to merge the two billing subscriptions. </summary>
    public partial class BillingSubscriptionMergeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingSubscriptionMergeContent"/>. </summary>
        public BillingSubscriptionMergeContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingSubscriptionMergeContent"/>. </summary>
        /// <param name="targetBillingSubscriptionName"> The ID of the target billing subscription that will be merged with the source subscription provided in the request. </param>
        /// <param name="quantity"> The quantity of the source billing subscription that will be merged with the target billing subscription. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingSubscriptionMergeContent(string targetBillingSubscriptionName, int? quantity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetBillingSubscriptionName = targetBillingSubscriptionName;
            Quantity = quantity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The ID of the target billing subscription that will be merged with the source subscription provided in the request. </summary>
        [WirePath("targetBillingSubscriptionName")]
        public string TargetBillingSubscriptionName { get; set; }
        /// <summary> The quantity of the source billing subscription that will be merged with the target billing subscription. </summary>
        [WirePath("quantity")]
        public int? Quantity { get; set; }
    }
}
