// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> A container for a list of resources. </summary>
    internal partial class BillingSubscriptionListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingSubscriptionListResult"/>. </summary>
        internal BillingSubscriptionListResult()
        {
            Value = new ChangeTrackingList<BillingSubscriptionData>();
        }

        /// <summary> Initializes a new instance of <see cref="BillingSubscriptionListResult"/>. </summary>
        /// <param name="nextLink"> The link (url) to the next page of results. </param>
        /// <param name="totalCount"> Total number of records. </param>
        /// <param name="value"> The list of resources. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingSubscriptionListResult(string nextLink, int? totalCount, IReadOnlyList<BillingSubscriptionData> value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NextLink = nextLink;
            TotalCount = totalCount;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The link (url) to the next page of results. </summary>
        public string NextLink { get; }
        /// <summary> Total number of records. </summary>
        public int? TotalCount { get; }
        /// <summary> The list of resources. </summary>
        public IReadOnlyList<BillingSubscriptionData> Value { get; }
    }
}
