// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Indicates whether auto renewal is turned on or off for a product. </summary>
    public readonly partial struct BillingSubscriptionAutoRenewState : IEquatable<BillingSubscriptionAutoRenewState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingSubscriptionAutoRenewState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingSubscriptionAutoRenewState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OffValue = "Off";
        private const string OnValue = "On";

        /// <summary> Off. </summary>
        public static BillingSubscriptionAutoRenewState Off { get; } = new BillingSubscriptionAutoRenewState(OffValue);
        /// <summary> On. </summary>
        public static BillingSubscriptionAutoRenewState On { get; } = new BillingSubscriptionAutoRenewState(OnValue);
        /// <summary> Determines if two <see cref="BillingSubscriptionAutoRenewState"/> values are the same. </summary>
        public static bool operator ==(BillingSubscriptionAutoRenewState left, BillingSubscriptionAutoRenewState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingSubscriptionAutoRenewState"/> values are not the same. </summary>
        public static bool operator !=(BillingSubscriptionAutoRenewState left, BillingSubscriptionAutoRenewState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingSubscriptionAutoRenewState"/>. </summary>
        public static implicit operator BillingSubscriptionAutoRenewState(string value) => new BillingSubscriptionAutoRenewState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingSubscriptionAutoRenewState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingSubscriptionAutoRenewState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
