// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The billing profile spending limit. </summary>
    public readonly partial struct BillingSpendingLimit : IEquatable<BillingSpendingLimit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingSpendingLimit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingSpendingLimit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OffValue = "Off";
        private const string OnValue = "On";

        /// <summary> Off. </summary>
        public static BillingSpendingLimit Off { get; } = new BillingSpendingLimit(OffValue);
        /// <summary> On. </summary>
        public static BillingSpendingLimit On { get; } = new BillingSpendingLimit(OnValue);
        /// <summary> Determines if two <see cref="BillingSpendingLimit"/> values are the same. </summary>
        public static bool operator ==(BillingSpendingLimit left, BillingSpendingLimit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingSpendingLimit"/> values are not the same. </summary>
        public static bool operator !=(BillingSpendingLimit left, BillingSpendingLimit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingSpendingLimit"/>. </summary>
        public static implicit operator BillingSpendingLimit(string value) => new BillingSpendingLimit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingSpendingLimit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingSpendingLimit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
