// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Represents the Savings plan term in ISO 8601 format. </summary>
    public readonly partial struct BillingSavingsPlanTerm : IEquatable<BillingSavingsPlanTerm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingSavingsPlanTerm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingSavingsPlanTerm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string P1YValue = "P1Y";
        private const string P3YValue = "P3Y";
        private const string P5YValue = "P5Y";

        /// <summary> P1Y. </summary>
        public static BillingSavingsPlanTerm P1Y { get; } = new BillingSavingsPlanTerm(P1YValue);
        /// <summary> P3Y. </summary>
        public static BillingSavingsPlanTerm P3Y { get; } = new BillingSavingsPlanTerm(P3YValue);
        /// <summary> P5Y. </summary>
        public static BillingSavingsPlanTerm P5Y { get; } = new BillingSavingsPlanTerm(P5YValue);
        /// <summary> Determines if two <see cref="BillingSavingsPlanTerm"/> values are the same. </summary>
        public static bool operator ==(BillingSavingsPlanTerm left, BillingSavingsPlanTerm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingSavingsPlanTerm"/> values are not the same. </summary>
        public static bool operator !=(BillingSavingsPlanTerm left, BillingSavingsPlanTerm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingSavingsPlanTerm"/>. </summary>
        public static implicit operator BillingSavingsPlanTerm(string value) => new BillingSavingsPlanTerm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingSavingsPlanTerm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingSavingsPlanTerm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
