// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The properties of the billing role assignment. </summary>
    public partial class BillingRoleAssignmentProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingRoleAssignmentProperties"/>. </summary>
        /// <param name="roleDefinitionId"> The ID of the role definition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="roleDefinitionId"/> is null. </exception>
        public BillingRoleAssignmentProperties(ResourceIdentifier roleDefinitionId)
        {
            Argument.AssertNotNull(roleDefinitionId, nameof(roleDefinitionId));

            RoleDefinitionId = roleDefinitionId;
        }

        /// <summary> Initializes a new instance of <see cref="BillingRoleAssignmentProperties"/>. </summary>
        /// <param name="provisioningState"> The provisioning state of the resource during a long-running operation. </param>
        /// <param name="createdOn"> The date the role assignment was created. </param>
        /// <param name="createdByPrincipalTenantId"> The tenant Id of the user who created the role assignment. </param>
        /// <param name="createdByPrincipalId"> The object ID of the user who created the role assignment. </param>
        /// <param name="createdByPrincipalPuid"> The principal PUID of the user who created the role assignment. </param>
        /// <param name="createdByUserEmailAddress"> The email address of the user who created the role assignment. This is supported only for billing accounts with agreement type Enterprise Agreement. </param>
        /// <param name="modifiedOn"> The date the role assignment was modified. </param>
        /// <param name="modifiedByPrincipalPuid"> The principal PUID of the user who modified the role assignment. </param>
        /// <param name="modifiedByUserEmailAddress"> The email address of the user who modified the role assignment. This is supported only for billing accounts with agreement type Enterprise Agreement. </param>
        /// <param name="modifiedByPrincipalId"> The principal PUID of the user who modified the role assignment. </param>
        /// <param name="modifiedByPrincipalTenantId"> The tenant Id of the user who modified the role assignment. </param>
        /// <param name="principalPuid"> The principal PUID of the user to whom the role was assigned. </param>
        /// <param name="principalId"> The object id of the user to whom the role was assigned. </param>
        /// <param name="principalTenantId"> The principal tenant id of the user to whom the role was assigned. </param>
        /// <param name="roleDefinitionId"> The ID of the role definition. </param>
        /// <param name="scope"> The scope at which the role was assigned. </param>
        /// <param name="userAuthenticationType"> The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement. </param>
        /// <param name="userEmailAddress"> The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement. </param>
        /// <param name="principalTenantName"> The friendly name of the tenant of the user to whom the role was assigned. This will be 'Primary Tenant' for the primary tenant of the billing account. </param>
        /// <param name="principalDisplayName"> The display name of the principal to whom the role was assigned. </param>
        /// <param name="principalType"> The type of a role Assignment. </param>
        /// <param name="billingRequestId"> The ID of the billing request that was created for the role assignment. This is only applicable to cross tenant role assignments or role assignments created through the billing request. </param>
        /// <param name="billingAccountId"> The fully qualified ID that uniquely identifies a billing account. </param>
        /// <param name="billingAccountDisplayName"> The name of the billing account. </param>
        /// <param name="billingProfileId"> The fully qualified ID that uniquely identifies a billing profile. </param>
        /// <param name="billingProfileDisplayName"> The name of the billing profile. </param>
        /// <param name="invoiceSectionId"> The fully qualified ID that uniquely identifies an invoice section. </param>
        /// <param name="invoiceSectionDisplayName"> The name of the invoice section. </param>
        /// <param name="customerId"> The fully qualified ID that uniquely identifies a customer. </param>
        /// <param name="customerDisplayName"> The name of the customer. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingRoleAssignmentProperties(BillingProvisioningState? provisioningState, DateTimeOffset? createdOn, Guid? createdByPrincipalTenantId, string createdByPrincipalId, string createdByPrincipalPuid, string createdByUserEmailAddress, DateTimeOffset? modifiedOn, string modifiedByPrincipalPuid, string modifiedByUserEmailAddress, string modifiedByPrincipalId, Guid? modifiedByPrincipalTenantId, string principalPuid, string principalId, Guid? principalTenantId, ResourceIdentifier roleDefinitionId, string scope, string userAuthenticationType, string userEmailAddress, string principalTenantName, string principalDisplayName, BillingPrincipalType? principalType, ResourceIdentifier billingRequestId, ResourceIdentifier billingAccountId, string billingAccountDisplayName, ResourceIdentifier billingProfileId, string billingProfileDisplayName, ResourceIdentifier invoiceSectionId, string invoiceSectionDisplayName, ResourceIdentifier customerId, string customerDisplayName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            CreatedOn = createdOn;
            CreatedByPrincipalTenantId = createdByPrincipalTenantId;
            CreatedByPrincipalId = createdByPrincipalId;
            CreatedByPrincipalPuid = createdByPrincipalPuid;
            CreatedByUserEmailAddress = createdByUserEmailAddress;
            ModifiedOn = modifiedOn;
            ModifiedByPrincipalPuid = modifiedByPrincipalPuid;
            ModifiedByUserEmailAddress = modifiedByUserEmailAddress;
            ModifiedByPrincipalId = modifiedByPrincipalId;
            ModifiedByPrincipalTenantId = modifiedByPrincipalTenantId;
            PrincipalPuid = principalPuid;
            PrincipalId = principalId;
            PrincipalTenantId = principalTenantId;
            RoleDefinitionId = roleDefinitionId;
            Scope = scope;
            UserAuthenticationType = userAuthenticationType;
            UserEmailAddress = userEmailAddress;
            PrincipalTenantName = principalTenantName;
            PrincipalDisplayName = principalDisplayName;
            PrincipalType = principalType;
            BillingRequestId = billingRequestId;
            BillingAccountId = billingAccountId;
            BillingAccountDisplayName = billingAccountDisplayName;
            BillingProfileId = billingProfileId;
            BillingProfileDisplayName = billingProfileDisplayName;
            InvoiceSectionId = invoiceSectionId;
            InvoiceSectionDisplayName = invoiceSectionDisplayName;
            CustomerId = customerId;
            CustomerDisplayName = customerDisplayName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BillingRoleAssignmentProperties"/> for deserialization. </summary>
        internal BillingRoleAssignmentProperties()
        {
        }

        /// <summary> The provisioning state of the resource during a long-running operation. </summary>
        [WirePath("provisioningState")]
        public BillingProvisioningState? ProvisioningState { get; }
        /// <summary> The date the role assignment was created. </summary>
        [WirePath("createdOn")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The tenant Id of the user who created the role assignment. </summary>
        [WirePath("createdByPrincipalTenantId")]
        public Guid? CreatedByPrincipalTenantId { get; }
        /// <summary> The object ID of the user who created the role assignment. </summary>
        [WirePath("createdByPrincipalId")]
        public string CreatedByPrincipalId { get; }
        /// <summary> The principal PUID of the user who created the role assignment. </summary>
        [WirePath("createdByPrincipalPuid")]
        public string CreatedByPrincipalPuid { get; }
        /// <summary> The email address of the user who created the role assignment. This is supported only for billing accounts with agreement type Enterprise Agreement. </summary>
        [WirePath("createdByUserEmailAddress")]
        public string CreatedByUserEmailAddress { get; }
        /// <summary> The date the role assignment was modified. </summary>
        [WirePath("modifiedOn")]
        public DateTimeOffset? ModifiedOn { get; }
        /// <summary> The principal PUID of the user who modified the role assignment. </summary>
        [WirePath("modifiedByPrincipalPuid")]
        public string ModifiedByPrincipalPuid { get; }
        /// <summary> The email address of the user who modified the role assignment. This is supported only for billing accounts with agreement type Enterprise Agreement. </summary>
        [WirePath("modifiedByUserEmailAddress")]
        public string ModifiedByUserEmailAddress { get; }
        /// <summary> The principal PUID of the user who modified the role assignment. </summary>
        [WirePath("modifiedByPrincipalId")]
        public string ModifiedByPrincipalId { get; }
        /// <summary> The tenant Id of the user who modified the role assignment. </summary>
        [WirePath("modifiedByPrincipalTenantId")]
        public Guid? ModifiedByPrincipalTenantId { get; }
        /// <summary> The principal PUID of the user to whom the role was assigned. </summary>
        [WirePath("principalPuid")]
        public string PrincipalPuid { get; set; }
        /// <summary> The object id of the user to whom the role was assigned. </summary>
        [WirePath("principalId")]
        public string PrincipalId { get; set; }
        /// <summary> The principal tenant id of the user to whom the role was assigned. </summary>
        [WirePath("principalTenantId")]
        public Guid? PrincipalTenantId { get; set; }
        /// <summary> The ID of the role definition. </summary>
        [WirePath("roleDefinitionId")]
        public ResourceIdentifier RoleDefinitionId { get; set; }
        /// <summary> The scope at which the role was assigned. </summary>
        [WirePath("scope")]
        public string Scope { get; set; }
        /// <summary> The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement. </summary>
        [WirePath("userAuthenticationType")]
        public string UserAuthenticationType { get; set; }
        /// <summary> The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement. </summary>
        [WirePath("userEmailAddress")]
        public string UserEmailAddress { get; set; }
        /// <summary> The friendly name of the tenant of the user to whom the role was assigned. This will be 'Primary Tenant' for the primary tenant of the billing account. </summary>
        [WirePath("principalTenantName")]
        public string PrincipalTenantName { get; }
        /// <summary> The display name of the principal to whom the role was assigned. </summary>
        [WirePath("principalDisplayName")]
        public string PrincipalDisplayName { get; }
        /// <summary> The type of a role Assignment. </summary>
        [WirePath("principalType")]
        public BillingPrincipalType? PrincipalType { get; }
        /// <summary> The ID of the billing request that was created for the role assignment. This is only applicable to cross tenant role assignments or role assignments created through the billing request. </summary>
        [WirePath("billingRequestId")]
        public ResourceIdentifier BillingRequestId { get; }
        /// <summary> The fully qualified ID that uniquely identifies a billing account. </summary>
        [WirePath("billingAccountId")]
        public ResourceIdentifier BillingAccountId { get; }
        /// <summary> The name of the billing account. </summary>
        [WirePath("billingAccountDisplayName")]
        public string BillingAccountDisplayName { get; }
        /// <summary> The fully qualified ID that uniquely identifies a billing profile. </summary>
        [WirePath("billingProfileId")]
        public ResourceIdentifier BillingProfileId { get; }
        /// <summary> The name of the billing profile. </summary>
        [WirePath("billingProfileDisplayName")]
        public string BillingProfileDisplayName { get; }
        /// <summary> The fully qualified ID that uniquely identifies an invoice section. </summary>
        [WirePath("invoiceSectionId")]
        public ResourceIdentifier InvoiceSectionId { get; }
        /// <summary> The name of the invoice section. </summary>
        [WirePath("invoiceSectionDisplayName")]
        public string InvoiceSectionDisplayName { get; }
        /// <summary> The fully qualified ID that uniquely identifies a customer. </summary>
        [WirePath("customerId")]
        public ResourceIdentifier CustomerId { get; }
        /// <summary> The name of the customer. </summary>
        [WirePath("customerDisplayName")]
        public string CustomerDisplayName { get; }
    }
}
