// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class BillingRoleAssignmentProperties : IUtf8JsonSerializable, IJsonModel<BillingRoleAssignmentProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BillingRoleAssignmentProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BillingRoleAssignmentProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingRoleAssignmentProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingRoleAssignmentProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("createdOn"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedByPrincipalTenantId))
            {
                writer.WritePropertyName("createdByPrincipalTenantId"u8);
                writer.WriteStringValue(CreatedByPrincipalTenantId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedByPrincipalId))
            {
                writer.WritePropertyName("createdByPrincipalId"u8);
                writer.WriteStringValue(CreatedByPrincipalId);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedByPrincipalPuid))
            {
                writer.WritePropertyName("createdByPrincipalPuid"u8);
                writer.WriteStringValue(CreatedByPrincipalPuid);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedByUserEmailAddress))
            {
                writer.WritePropertyName("createdByUserEmailAddress"u8);
                writer.WriteStringValue(CreatedByUserEmailAddress);
            }
            if (options.Format != "W" && Optional.IsDefined(ModifiedOn))
            {
                writer.WritePropertyName("modifiedOn"u8);
                writer.WriteStringValue(ModifiedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ModifiedByPrincipalPuid))
            {
                writer.WritePropertyName("modifiedByPrincipalPuid"u8);
                writer.WriteStringValue(ModifiedByPrincipalPuid);
            }
            if (options.Format != "W" && Optional.IsDefined(ModifiedByUserEmailAddress))
            {
                writer.WritePropertyName("modifiedByUserEmailAddress"u8);
                writer.WriteStringValue(ModifiedByUserEmailAddress);
            }
            if (options.Format != "W" && Optional.IsDefined(ModifiedByPrincipalId))
            {
                writer.WritePropertyName("modifiedByPrincipalId"u8);
                writer.WriteStringValue(ModifiedByPrincipalId);
            }
            if (options.Format != "W" && Optional.IsDefined(ModifiedByPrincipalTenantId))
            {
                writer.WritePropertyName("modifiedByPrincipalTenantId"u8);
                writer.WriteStringValue(ModifiedByPrincipalTenantId.Value);
            }
            if (Optional.IsDefined(PrincipalPuid))
            {
                writer.WritePropertyName("principalPuid"u8);
                writer.WriteStringValue(PrincipalPuid);
            }
            if (Optional.IsDefined(PrincipalId))
            {
                writer.WritePropertyName("principalId"u8);
                writer.WriteStringValue(PrincipalId);
            }
            if (Optional.IsDefined(PrincipalTenantId))
            {
                writer.WritePropertyName("principalTenantId"u8);
                writer.WriteStringValue(PrincipalTenantId.Value);
            }
            writer.WritePropertyName("roleDefinitionId"u8);
            writer.WriteStringValue(RoleDefinitionId);
            if (Optional.IsDefined(Scope))
            {
                writer.WritePropertyName("scope"u8);
                writer.WriteStringValue(Scope);
            }
            if (Optional.IsDefined(UserAuthenticationType))
            {
                writer.WritePropertyName("userAuthenticationType"u8);
                writer.WriteStringValue(UserAuthenticationType);
            }
            if (Optional.IsDefined(UserEmailAddress))
            {
                writer.WritePropertyName("userEmailAddress"u8);
                writer.WriteStringValue(UserEmailAddress);
            }
            if (options.Format != "W" && Optional.IsDefined(PrincipalTenantName))
            {
                writer.WritePropertyName("principalTenantName"u8);
                writer.WriteStringValue(PrincipalTenantName);
            }
            if (options.Format != "W" && Optional.IsDefined(PrincipalDisplayName))
            {
                writer.WritePropertyName("principalDisplayName"u8);
                writer.WriteStringValue(PrincipalDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(PrincipalType))
            {
                writer.WritePropertyName("principalType"u8);
                writer.WriteStringValue(PrincipalType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(BillingRequestId))
            {
                writer.WritePropertyName("billingRequestId"u8);
                writer.WriteStringValue(BillingRequestId);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingAccountId))
            {
                writer.WritePropertyName("billingAccountId"u8);
                writer.WriteStringValue(BillingAccountId);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingAccountDisplayName))
            {
                writer.WritePropertyName("billingAccountDisplayName"u8);
                writer.WriteStringValue(BillingAccountDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingProfileId))
            {
                writer.WritePropertyName("billingProfileId"u8);
                writer.WriteStringValue(BillingProfileId);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingProfileDisplayName))
            {
                writer.WritePropertyName("billingProfileDisplayName"u8);
                writer.WriteStringValue(BillingProfileDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceSectionId))
            {
                writer.WritePropertyName("invoiceSectionId"u8);
                writer.WriteStringValue(InvoiceSectionId);
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceSectionDisplayName))
            {
                writer.WritePropertyName("invoiceSectionDisplayName"u8);
                writer.WriteStringValue(InvoiceSectionDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(CustomerId))
            {
                writer.WritePropertyName("customerId"u8);
                writer.WriteStringValue(CustomerId);
            }
            if (options.Format != "W" && Optional.IsDefined(CustomerDisplayName))
            {
                writer.WritePropertyName("customerDisplayName"u8);
                writer.WriteStringValue(CustomerDisplayName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BillingRoleAssignmentProperties IJsonModel<BillingRoleAssignmentProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingRoleAssignmentProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingRoleAssignmentProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBillingRoleAssignmentProperties(document.RootElement, options);
        }

        internal static BillingRoleAssignmentProperties DeserializeBillingRoleAssignmentProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BillingProvisioningState? provisioningState = default;
            DateTimeOffset? createdOn = default;
            Guid? createdByPrincipalTenantId = default;
            string createdByPrincipalId = default;
            string createdByPrincipalPuid = default;
            string createdByUserEmailAddress = default;
            DateTimeOffset? modifiedOn = default;
            string modifiedByPrincipalPuid = default;
            string modifiedByUserEmailAddress = default;
            string modifiedByPrincipalId = default;
            Guid? modifiedByPrincipalTenantId = default;
            string principalPuid = default;
            string principalId = default;
            Guid? principalTenantId = default;
            ResourceIdentifier roleDefinitionId = default;
            string scope = default;
            string userAuthenticationType = default;
            string userEmailAddress = default;
            string principalTenantName = default;
            string principalDisplayName = default;
            BillingPrincipalType? principalType = default;
            ResourceIdentifier billingRequestId = default;
            ResourceIdentifier billingAccountId = default;
            string billingAccountDisplayName = default;
            ResourceIdentifier billingProfileId = default;
            string billingProfileDisplayName = default;
            ResourceIdentifier invoiceSectionId = default;
            string invoiceSectionDisplayName = default;
            ResourceIdentifier customerId = default;
            string customerDisplayName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new BillingProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("createdOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    createdOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("createdByPrincipalTenantId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    createdByPrincipalTenantId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("createdByPrincipalId"u8))
                {
                    createdByPrincipalId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("createdByPrincipalPuid"u8))
                {
                    createdByPrincipalPuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("createdByUserEmailAddress"u8))
                {
                    createdByUserEmailAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("modifiedOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    modifiedOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("modifiedByPrincipalPuid"u8))
                {
                    modifiedByPrincipalPuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("modifiedByUserEmailAddress"u8))
                {
                    modifiedByUserEmailAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("modifiedByPrincipalId"u8))
                {
                    modifiedByPrincipalId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("modifiedByPrincipalTenantId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    modifiedByPrincipalTenantId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("principalPuid"u8))
                {
                    principalPuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("principalId"u8))
                {
                    principalId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("principalTenantId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    principalTenantId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("roleDefinitionId"u8))
                {
                    roleDefinitionId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("scope"u8))
                {
                    scope = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("userAuthenticationType"u8))
                {
                    userAuthenticationType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("userEmailAddress"u8))
                {
                    userEmailAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("principalTenantName"u8))
                {
                    principalTenantName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("principalDisplayName"u8))
                {
                    principalDisplayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("principalType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    principalType = new BillingPrincipalType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("billingRequestId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    billingRequestId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("billingAccountId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    billingAccountId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("billingAccountDisplayName"u8))
                {
                    billingAccountDisplayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("billingProfileId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    billingProfileId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("billingProfileDisplayName"u8))
                {
                    billingProfileDisplayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("invoiceSectionId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invoiceSectionId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("invoiceSectionDisplayName"u8))
                {
                    invoiceSectionDisplayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("customerId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    customerId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("customerDisplayName"u8))
                {
                    customerDisplayName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BillingRoleAssignmentProperties(
                provisioningState,
                createdOn,
                createdByPrincipalTenantId,
                createdByPrincipalId,
                createdByPrincipalPuid,
                createdByUserEmailAddress,
                modifiedOn,
                modifiedByPrincipalPuid,
                modifiedByUserEmailAddress,
                modifiedByPrincipalId,
                modifiedByPrincipalTenantId,
                principalPuid,
                principalId,
                principalTenantId,
                roleDefinitionId,
                scope,
                userAuthenticationType,
                userEmailAddress,
                principalTenantName,
                principalDisplayName,
                principalType,
                billingRequestId,
                billingAccountId,
                billingAccountDisplayName,
                billingProfileId,
                billingProfileDisplayName,
                invoiceSectionId,
                invoiceSectionDisplayName,
                customerId,
                customerDisplayName,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("  provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  createdOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreatedOn))
                {
                    builder.Append("  createdOn: ");
                    var formattedDateTimeString = TypeFormatters.ToString(CreatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreatedByPrincipalTenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  createdByPrincipalTenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreatedByPrincipalTenantId))
                {
                    builder.Append("  createdByPrincipalTenantId: ");
                    builder.AppendLine($"'{CreatedByPrincipalTenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreatedByPrincipalId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  createdByPrincipalId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreatedByPrincipalId))
                {
                    builder.Append("  createdByPrincipalId: ");
                    if (CreatedByPrincipalId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CreatedByPrincipalId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CreatedByPrincipalId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreatedByPrincipalPuid), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  createdByPrincipalPuid: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreatedByPrincipalPuid))
                {
                    builder.Append("  createdByPrincipalPuid: ");
                    if (CreatedByPrincipalPuid.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CreatedByPrincipalPuid}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CreatedByPrincipalPuid}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreatedByUserEmailAddress), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  createdByUserEmailAddress: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreatedByUserEmailAddress))
                {
                    builder.Append("  createdByUserEmailAddress: ");
                    if (CreatedByUserEmailAddress.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CreatedByUserEmailAddress}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CreatedByUserEmailAddress}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ModifiedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  modifiedOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ModifiedOn))
                {
                    builder.Append("  modifiedOn: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ModifiedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ModifiedByPrincipalPuid), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  modifiedByPrincipalPuid: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ModifiedByPrincipalPuid))
                {
                    builder.Append("  modifiedByPrincipalPuid: ");
                    if (ModifiedByPrincipalPuid.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ModifiedByPrincipalPuid}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ModifiedByPrincipalPuid}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ModifiedByUserEmailAddress), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  modifiedByUserEmailAddress: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ModifiedByUserEmailAddress))
                {
                    builder.Append("  modifiedByUserEmailAddress: ");
                    if (ModifiedByUserEmailAddress.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ModifiedByUserEmailAddress}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ModifiedByUserEmailAddress}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ModifiedByPrincipalId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  modifiedByPrincipalId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ModifiedByPrincipalId))
                {
                    builder.Append("  modifiedByPrincipalId: ");
                    if (ModifiedByPrincipalId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ModifiedByPrincipalId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ModifiedByPrincipalId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ModifiedByPrincipalTenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  modifiedByPrincipalTenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ModifiedByPrincipalTenantId))
                {
                    builder.Append("  modifiedByPrincipalTenantId: ");
                    builder.AppendLine($"'{ModifiedByPrincipalTenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrincipalPuid), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  principalPuid: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrincipalPuid))
                {
                    builder.Append("  principalPuid: ");
                    if (PrincipalPuid.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PrincipalPuid}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PrincipalPuid}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrincipalId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  principalId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrincipalId))
                {
                    builder.Append("  principalId: ");
                    if (PrincipalId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PrincipalId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PrincipalId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrincipalTenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  principalTenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrincipalTenantId))
                {
                    builder.Append("  principalTenantId: ");
                    builder.AppendLine($"'{PrincipalTenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RoleDefinitionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  roleDefinitionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RoleDefinitionId))
                {
                    builder.Append("  roleDefinitionId: ");
                    builder.AppendLine($"'{RoleDefinitionId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Scope), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  scope: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Scope))
                {
                    builder.Append("  scope: ");
                    if (Scope.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Scope}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Scope}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UserAuthenticationType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  userAuthenticationType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UserAuthenticationType))
                {
                    builder.Append("  userAuthenticationType: ");
                    if (UserAuthenticationType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{UserAuthenticationType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{UserAuthenticationType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UserEmailAddress), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  userEmailAddress: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UserEmailAddress))
                {
                    builder.Append("  userEmailAddress: ");
                    if (UserEmailAddress.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{UserEmailAddress}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{UserEmailAddress}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrincipalTenantName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  principalTenantName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrincipalTenantName))
                {
                    builder.Append("  principalTenantName: ");
                    if (PrincipalTenantName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PrincipalTenantName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PrincipalTenantName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrincipalDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  principalDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrincipalDisplayName))
                {
                    builder.Append("  principalDisplayName: ");
                    if (PrincipalDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PrincipalDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PrincipalDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrincipalType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  principalType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrincipalType))
                {
                    builder.Append("  principalType: ");
                    builder.AppendLine($"'{PrincipalType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingRequestId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billingRequestId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingRequestId))
                {
                    builder.Append("  billingRequestId: ");
                    builder.AppendLine($"'{BillingRequestId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingAccountId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billingAccountId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingAccountId))
                {
                    builder.Append("  billingAccountId: ");
                    builder.AppendLine($"'{BillingAccountId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingAccountDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billingAccountDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingAccountDisplayName))
                {
                    builder.Append("  billingAccountDisplayName: ");
                    if (BillingAccountDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BillingAccountDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BillingAccountDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingProfileId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billingProfileId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingProfileId))
                {
                    builder.Append("  billingProfileId: ");
                    builder.AppendLine($"'{BillingProfileId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingProfileDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billingProfileDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingProfileDisplayName))
                {
                    builder.Append("  billingProfileDisplayName: ");
                    if (BillingProfileDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BillingProfileDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BillingProfileDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceSectionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoiceSectionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoiceSectionId))
                {
                    builder.Append("  invoiceSectionId: ");
                    builder.AppendLine($"'{InvoiceSectionId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceSectionDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoiceSectionDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoiceSectionDisplayName))
                {
                    builder.Append("  invoiceSectionDisplayName: ");
                    if (InvoiceSectionDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{InvoiceSectionDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{InvoiceSectionDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomerId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  customerId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CustomerId))
                {
                    builder.Append("  customerId: ");
                    builder.AppendLine($"'{CustomerId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomerDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  customerDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CustomerDisplayName))
                {
                    builder.Append("  customerDisplayName: ");
                    if (CustomerDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CustomerDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CustomerDisplayName}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<BillingRoleAssignmentProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingRoleAssignmentProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(BillingRoleAssignmentProperties)} does not support writing '{options.Format}' format.");
            }
        }

        BillingRoleAssignmentProperties IPersistableModel<BillingRoleAssignmentProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingRoleAssignmentProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBillingRoleAssignmentProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BillingRoleAssignmentProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BillingRoleAssignmentProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
