// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Type of billing request. </summary>
    public readonly partial struct BillingRequestType : IEquatable<BillingRequestType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingRequestType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingRequestType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string InvoiceAccessValue = "InvoiceAccess";
        private const string ProvisioningAccessValue = "ProvisioningAccess";
        private const string RoleAssignmentValue = "RoleAssignment";
        private const string UpdateBillingPolicyValue = "UpdateBillingPolicy";

        /// <summary> Other. </summary>
        public static BillingRequestType Other { get; } = new BillingRequestType(OtherValue);
        /// <summary> InvoiceAccess. </summary>
        public static BillingRequestType InvoiceAccess { get; } = new BillingRequestType(InvoiceAccessValue);
        /// <summary> ProvisioningAccess. </summary>
        public static BillingRequestType ProvisioningAccess { get; } = new BillingRequestType(ProvisioningAccessValue);
        /// <summary> RoleAssignment. </summary>
        public static BillingRequestType RoleAssignment { get; } = new BillingRequestType(RoleAssignmentValue);
        /// <summary> UpdateBillingPolicy. </summary>
        public static BillingRequestType UpdateBillingPolicy { get; } = new BillingRequestType(UpdateBillingPolicyValue);
        /// <summary> Determines if two <see cref="BillingRequestType"/> values are the same. </summary>
        public static bool operator ==(BillingRequestType left, BillingRequestType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingRequestType"/> values are not the same. </summary>
        public static bool operator !=(BillingRequestType left, BillingRequestType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingRequestType"/>. </summary>
        public static implicit operator BillingRequestType(string value) => new BillingRequestType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingRequestType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingRequestType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
