// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Status of billing request. </summary>
    public readonly partial struct BillingRequestStatus : IEquatable<BillingRequestStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingRequestStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingRequestStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string DeclinedValue = "Declined";
        private const string CancelledValue = "Cancelled";
        private const string CompletedValue = "Completed";
        private const string ExpiredValue = "Expired";

        /// <summary> Other. </summary>
        public static BillingRequestStatus Other { get; } = new BillingRequestStatus(OtherValue);
        /// <summary> Pending. </summary>
        public static BillingRequestStatus Pending { get; } = new BillingRequestStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static BillingRequestStatus Approved { get; } = new BillingRequestStatus(ApprovedValue);
        /// <summary> Declined. </summary>
        public static BillingRequestStatus Declined { get; } = new BillingRequestStatus(DeclinedValue);
        /// <summary> Cancelled. </summary>
        public static BillingRequestStatus Cancelled { get; } = new BillingRequestStatus(CancelledValue);
        /// <summary> Completed. </summary>
        public static BillingRequestStatus Completed { get; } = new BillingRequestStatus(CompletedValue);
        /// <summary> Expired. </summary>
        public static BillingRequestStatus Expired { get; } = new BillingRequestStatus(ExpiredValue);
        /// <summary> Determines if two <see cref="BillingRequestStatus"/> values are the same. </summary>
        public static bool operator ==(BillingRequestStatus left, BillingRequestStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingRequestStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingRequestStatus left, BillingRequestStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingRequestStatus"/>. </summary>
        public static implicit operator BillingRequestStatus(string value) => new BillingRequestStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingRequestStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingRequestStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
