// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> A request submitted by a user to manage billing. Users with an owner role on the scope can approve or decline these requests. </summary>
    public partial class BillingRequestProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingRequestProperties"/>. </summary>
        public BillingRequestProperties()
        {
            AdditionalInformation = new ChangeTrackingDictionary<string, string>();
            Recipients = new ChangeTrackingList<BillingPrincipal>();
        }

        /// <summary> Initializes a new instance of <see cref="BillingRequestProperties"/>. </summary>
        /// <param name="provisioningState"> The provisioning state of the resource during a long-running operation. </param>
        /// <param name="additionalInformation"> Additional information for the billing request. </param>
        /// <param name="reviewedBy"> The principal of the request reviewer. Will only be set if request is approved. </param>
        /// <param name="reviewalOn"> The date and time when the request was reviewed. </param>
        /// <param name="billingAccountId"> The fully qualified ID that uniquely identifies a billing account. </param>
        /// <param name="billingAccountName"> The ID that uniquely identifies a billing account. </param>
        /// <param name="billingAccountDisplayName"> The name of the billing account. </param>
        /// <param name="billingAccountPrimaryBillingTenantId"> The primary tenant ID of the billing account for which the billing request was submitted. </param>
        /// <param name="billingProfileId"> The fully qualified ID that uniquely identifies a billing profile. </param>
        /// <param name="billingProfileName"> The ID that uniquely identifies a billing profile. </param>
        /// <param name="billingProfileDisplayName"> The name of the billing profile. </param>
        /// <param name="createdBy"> The principal of the entity who created the request. </param>
        /// <param name="createdOn"> The date and time when the request was created. </param>
        /// <param name="expireOn"> The date and time when the request expires. </param>
        /// <param name="decisionReason"> The reason to approve or decline the request. </param>
        /// <param name="invoiceSectionId"> The fully qualified ID that uniquely identifies an invoice section. </param>
        /// <param name="invoiceSectionName"> The ID that uniquely identifies an invoice section. </param>
        /// <param name="invoiceSectionDisplayName"> The name of the invoice section. </param>
        /// <param name="customerId"> The fully qualified ID that uniquely identifies a customer. </param>
        /// <param name="customerName"> The ID that uniquely identifies a customer. </param>
        /// <param name="customerDisplayName"> The name of the customer. </param>
        /// <param name="subscriptionId"> The fully qualified ID that uniquely identifies a billing subscription. </param>
        /// <param name="subscriptionName"> The ID that uniquely identifies a billing subscription. </param>
        /// <param name="subscriptionDisplayName"> The name of the billing subscription. </param>
        /// <param name="justification"> Justification for submitting request. </param>
        /// <param name="recipients"> The recipients of the billing request. </param>
        /// <param name="requestScope"> The billing scope for which the request was submitted (ex. '/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}'). </param>
        /// <param name="billingScope"> The billing scope for which the request will be applied. This is a read only property derived by the service. </param>
        /// <param name="status"> Status of billing request. </param>
        /// <param name="requestType"> Type of billing request. </param>
        /// <param name="lastUpdatedBy"> The principal of the entity who last updated the request. </param>
        /// <param name="lastUpdatedOn"> Date and time of last update. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingRequestProperties(BillingProvisioningState? provisioningState, IDictionary<string, string> additionalInformation, BillingPrincipal reviewedBy, DateTimeOffset? reviewalOn, ResourceIdentifier billingAccountId, string billingAccountName, string billingAccountDisplayName, Guid? billingAccountPrimaryBillingTenantId, ResourceIdentifier billingProfileId, string billingProfileName, string billingProfileDisplayName, BillingPrincipal createdBy, DateTimeOffset? createdOn, DateTimeOffset? expireOn, string decisionReason, ResourceIdentifier invoiceSectionId, string invoiceSectionName, string invoiceSectionDisplayName, ResourceIdentifier customerId, string customerName, string customerDisplayName, string subscriptionId, string subscriptionName, string subscriptionDisplayName, string justification, IList<BillingPrincipal> recipients, string requestScope, string billingScope, BillingRequestStatus? status, BillingRequestType? requestType, BillingPrincipal lastUpdatedBy, DateTimeOffset? lastUpdatedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            AdditionalInformation = additionalInformation;
            ReviewedBy = reviewedBy;
            ReviewalOn = reviewalOn;
            BillingAccountId = billingAccountId;
            BillingAccountName = billingAccountName;
            BillingAccountDisplayName = billingAccountDisplayName;
            BillingAccountPrimaryBillingTenantId = billingAccountPrimaryBillingTenantId;
            BillingProfileId = billingProfileId;
            BillingProfileName = billingProfileName;
            BillingProfileDisplayName = billingProfileDisplayName;
            CreatedBy = createdBy;
            CreatedOn = createdOn;
            ExpireOn = expireOn;
            DecisionReason = decisionReason;
            InvoiceSectionId = invoiceSectionId;
            InvoiceSectionName = invoiceSectionName;
            InvoiceSectionDisplayName = invoiceSectionDisplayName;
            CustomerId = customerId;
            CustomerName = customerName;
            CustomerDisplayName = customerDisplayName;
            SubscriptionId = subscriptionId;
            SubscriptionName = subscriptionName;
            SubscriptionDisplayName = subscriptionDisplayName;
            Justification = justification;
            Recipients = recipients;
            RequestScope = requestScope;
            BillingScope = billingScope;
            Status = status;
            RequestType = requestType;
            LastUpdatedBy = lastUpdatedBy;
            LastUpdatedOn = lastUpdatedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The provisioning state of the resource during a long-running operation. </summary>
        [WirePath("provisioningState")]
        public BillingProvisioningState? ProvisioningState { get; }
        /// <summary> Additional information for the billing request. </summary>
        [WirePath("additionalInformation")]
        public IDictionary<string, string> AdditionalInformation { get; }
        /// <summary> The principal of the request reviewer. Will only be set if request is approved. </summary>
        [WirePath("reviewedBy")]
        public BillingPrincipal ReviewedBy { get; set; }
        /// <summary> The date and time when the request was reviewed. </summary>
        [WirePath("reviewalDate")]
        public DateTimeOffset? ReviewalOn { get; }
        /// <summary> The fully qualified ID that uniquely identifies a billing account. </summary>
        [WirePath("billingAccountId")]
        public ResourceIdentifier BillingAccountId { get; }
        /// <summary> The ID that uniquely identifies a billing account. </summary>
        [WirePath("billingAccountName")]
        public string BillingAccountName { get; }
        /// <summary> The name of the billing account. </summary>
        [WirePath("billingAccountDisplayName")]
        public string BillingAccountDisplayName { get; }
        /// <summary> The primary tenant ID of the billing account for which the billing request was submitted. </summary>
        [WirePath("billingAccountPrimaryBillingTenantId")]
        public Guid? BillingAccountPrimaryBillingTenantId { get; }
        /// <summary> The fully qualified ID that uniquely identifies a billing profile. </summary>
        [WirePath("billingProfileId")]
        public ResourceIdentifier BillingProfileId { get; }
        /// <summary> The ID that uniquely identifies a billing profile. </summary>
        [WirePath("billingProfileName")]
        public string BillingProfileName { get; }
        /// <summary> The name of the billing profile. </summary>
        [WirePath("billingProfileDisplayName")]
        public string BillingProfileDisplayName { get; }
        /// <summary> The principal of the entity who created the request. </summary>
        [WirePath("createdBy")]
        public BillingPrincipal CreatedBy { get; set; }
        /// <summary> The date and time when the request was created. </summary>
        [WirePath("creationDate")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The date and time when the request expires. </summary>
        [WirePath("expirationDate")]
        public DateTimeOffset? ExpireOn { get; }
        /// <summary> The reason to approve or decline the request. </summary>
        [WirePath("decisionReason")]
        public string DecisionReason { get; set; }
        /// <summary> The fully qualified ID that uniquely identifies an invoice section. </summary>
        [WirePath("invoiceSectionId")]
        public ResourceIdentifier InvoiceSectionId { get; }
        /// <summary> The ID that uniquely identifies an invoice section. </summary>
        [WirePath("invoiceSectionName")]
        public string InvoiceSectionName { get; }
        /// <summary> The name of the invoice section. </summary>
        [WirePath("invoiceSectionDisplayName")]
        public string InvoiceSectionDisplayName { get; }
        /// <summary> The fully qualified ID that uniquely identifies a customer. </summary>
        [WirePath("customerId")]
        public ResourceIdentifier CustomerId { get; }
        /// <summary> The ID that uniquely identifies a customer. </summary>
        [WirePath("customerName")]
        public string CustomerName { get; }
        /// <summary> The name of the customer. </summary>
        [WirePath("customerDisplayName")]
        public string CustomerDisplayName { get; }
        /// <summary> The fully qualified ID that uniquely identifies a billing subscription. </summary>
        [WirePath("subscriptionId")]
        public string SubscriptionId { get; }
        /// <summary> The ID that uniquely identifies a billing subscription. </summary>
        [WirePath("subscriptionName")]
        public string SubscriptionName { get; }
        /// <summary> The name of the billing subscription. </summary>
        [WirePath("subscriptionDisplayName")]
        public string SubscriptionDisplayName { get; }
        /// <summary> Justification for submitting request. </summary>
        [WirePath("justification")]
        public string Justification { get; set; }
        /// <summary> The recipients of the billing request. </summary>
        [WirePath("recipients")]
        public IList<BillingPrincipal> Recipients { get; }
        /// <summary> The billing scope for which the request was submitted (ex. '/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}'). </summary>
        [WirePath("requestScope")]
        public string RequestScope { get; set; }
        /// <summary> The billing scope for which the request will be applied. This is a read only property derived by the service. </summary>
        [WirePath("billingScope")]
        public string BillingScope { get; }
        /// <summary> Status of billing request. </summary>
        [WirePath("status")]
        public BillingRequestStatus? Status { get; set; }
        /// <summary> Type of billing request. </summary>
        [WirePath("type")]
        public BillingRequestType? RequestType { get; set; }
        /// <summary> The principal of the entity who last updated the request. </summary>
        [WirePath("lastUpdatedBy")]
        public BillingPrincipal LastUpdatedBy { get; set; }
        /// <summary> Date and time of last update. </summary>
        [WirePath("lastUpdatedDate")]
        public DateTimeOffset? LastUpdatedOn { get; }
    }
}
