// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Identifies the billing relationships represented by a billing account or billing profile. The billing relationship may be between Microsoft, the customer, and/or a third-party. </summary>
    public readonly partial struct BillingRelationshipType : IEquatable<BillingRelationshipType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingRelationshipType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingRelationshipType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string DirectValue = "Direct";
        private const string IndirectCustomerValue = "IndirectCustomer";
        private const string IndirectPartnerValue = "IndirectPartner";
        private const string CspPartnerValue = "CSPPartner";
        private const string CspCustomerValue = "CSPCustomer";

        /// <summary> Other. </summary>
        public static BillingRelationshipType Other { get; } = new BillingRelationshipType(OtherValue);
        /// <summary> Direct. </summary>
        public static BillingRelationshipType Direct { get; } = new BillingRelationshipType(DirectValue);
        /// <summary> IndirectCustomer. </summary>
        public static BillingRelationshipType IndirectCustomer { get; } = new BillingRelationshipType(IndirectCustomerValue);
        /// <summary> IndirectPartner. </summary>
        public static BillingRelationshipType IndirectPartner { get; } = new BillingRelationshipType(IndirectPartnerValue);
        /// <summary> CSPPartner. </summary>
        public static BillingRelationshipType CspPartner { get; } = new BillingRelationshipType(CspPartnerValue);
        /// <summary> CSPCustomer. </summary>
        public static BillingRelationshipType CspCustomer { get; } = new BillingRelationshipType(CspCustomerValue);
        /// <summary> Determines if two <see cref="BillingRelationshipType"/> values are the same. </summary>
        public static bool operator ==(BillingRelationshipType left, BillingRelationshipType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingRelationshipType"/> values are not the same. </summary>
        public static bool operator !=(BillingRelationshipType left, BillingRelationshipType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingRelationshipType"/>. </summary>
        public static implicit operator BillingRelationshipType(string value) => new BillingRelationshipType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingRelationshipType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingRelationshipType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
