// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The state determines whether subscriptions and licenses can be provisioned in the associated tenant. It can be set to 'Pending' to initiate a billing request. </summary>
    public readonly partial struct BillingProvisioningTenantState : IEquatable<BillingProvisioningTenantState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingProvisioningTenantState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingProvisioningTenantState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string NotRequestedValue = "NotRequested";
        private const string ActiveValue = "Active";
        private const string PendingValue = "Pending";
        private const string BillingRequestExpiredValue = "BillingRequestExpired";
        private const string BillingRequestDeclinedValue = "BillingRequestDeclined";
        private const string RevokedValue = "Revoked";

        /// <summary> Other. </summary>
        public static BillingProvisioningTenantState Other { get; } = new BillingProvisioningTenantState(OtherValue);
        /// <summary> NotRequested. </summary>
        public static BillingProvisioningTenantState NotRequested { get; } = new BillingProvisioningTenantState(NotRequestedValue);
        /// <summary> Active. </summary>
        public static BillingProvisioningTenantState Active { get; } = new BillingProvisioningTenantState(ActiveValue);
        /// <summary> Pending. </summary>
        public static BillingProvisioningTenantState Pending { get; } = new BillingProvisioningTenantState(PendingValue);
        /// <summary> BillingRequestExpired. </summary>
        public static BillingProvisioningTenantState BillingRequestExpired { get; } = new BillingProvisioningTenantState(BillingRequestExpiredValue);
        /// <summary> BillingRequestDeclined. </summary>
        public static BillingProvisioningTenantState BillingRequestDeclined { get; } = new BillingProvisioningTenantState(BillingRequestDeclinedValue);
        /// <summary> Revoked. </summary>
        public static BillingProvisioningTenantState Revoked { get; } = new BillingProvisioningTenantState(RevokedValue);
        /// <summary> Determines if two <see cref="BillingProvisioningTenantState"/> values are the same. </summary>
        public static bool operator ==(BillingProvisioningTenantState left, BillingProvisioningTenantState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingProvisioningTenantState"/> values are not the same. </summary>
        public static bool operator !=(BillingProvisioningTenantState left, BillingProvisioningTenantState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingProvisioningTenantState"/>. </summary>
        public static implicit operator BillingProvisioningTenantState(string value) => new BillingProvisioningTenantState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingProvisioningTenantState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingProvisioningTenantState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
