// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The provisioning state of the resource during a long-running operation. </summary>
    public readonly partial struct BillingProvisioningState : IEquatable<BillingProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string NewValue = "New";
        private const string PendingValue = "Pending";
        private const string ProvisioningValue = "Provisioning";
        private const string PendingBillingValue = "PendingBilling";
        private const string ConfirmedBillingValue = "ConfirmedBilling";
        private const string CreatingValue = "Creating";
        private const string CreatedValue = "Created";
        private const string ExpiredValue = "Expired";

        /// <summary> Succeeded. </summary>
        public static BillingProvisioningState Succeeded { get; } = new BillingProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static BillingProvisioningState Canceled { get; } = new BillingProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static BillingProvisioningState Failed { get; } = new BillingProvisioningState(FailedValue);
        /// <summary> New. </summary>
        public static BillingProvisioningState New { get; } = new BillingProvisioningState(NewValue);
        /// <summary> Pending. </summary>
        public static BillingProvisioningState Pending { get; } = new BillingProvisioningState(PendingValue);
        /// <summary> Provisioning. </summary>
        public static BillingProvisioningState Provisioning { get; } = new BillingProvisioningState(ProvisioningValue);
        /// <summary> PendingBilling. </summary>
        public static BillingProvisioningState PendingBilling { get; } = new BillingProvisioningState(PendingBillingValue);
        /// <summary> ConfirmedBilling. </summary>
        public static BillingProvisioningState ConfirmedBilling { get; } = new BillingProvisioningState(ConfirmedBillingValue);
        /// <summary> Creating. </summary>
        public static BillingProvisioningState Creating { get; } = new BillingProvisioningState(CreatingValue);
        /// <summary> Created. </summary>
        public static BillingProvisioningState Created { get; } = new BillingProvisioningState(CreatedValue);
        /// <summary> Expired. </summary>
        public static BillingProvisioningState Expired { get; } = new BillingProvisioningState(ExpiredValue);
        /// <summary> Determines if two <see cref="BillingProvisioningState"/> values are the same. </summary>
        public static bool operator ==(BillingProvisioningState left, BillingProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(BillingProvisioningState left, BillingProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingProvisioningState"/>. </summary>
        public static implicit operator BillingProvisioningState(string value) => new BillingProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
