// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> A billing property. </summary>
    public partial class BillingPropertyProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingPropertyProperties"/>. </summary>
        public BillingPropertyProperties()
        {
            BillingProfileSpendingLimitDetails = new ChangeTrackingList<SpendingLimitDetails>();
            SubscriptionBillingStatusDetails = new ChangeTrackingList<BillingSubscriptionStatusDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="BillingPropertyProperties"/>. </summary>
        /// <param name="billingAccountAgreementType"> The type of agreement. </param>
        /// <param name="billingAccountDisplayName"> The name of the billing account. </param>
        /// <param name="billingAccountId"> The fully qualified ID that uniquely identifies a billing account. </param>
        /// <param name="accountAdminNotificationEmailAddress"> Notification email address for legacy account. Available for agreement type Microsoft Online Services Program. </param>
        /// <param name="billingAccountSoldToCountry"> The country of the individual or organization that is responsible for the billing account. </param>
        /// <param name="billingAccountStatus"> The current status of the billing account. </param>
        /// <param name="billingAccountStatusReasonCode"> Reason for the specified billing account status. </param>
        /// <param name="billingAccountType"> The type of customer. </param>
        /// <param name="billingAccountSubType"> The tier of the account. </param>
        /// <param name="billingCurrency"> The billing currency for the subscription. Available for billing accounts with agreement type Enterprise Agreement. </param>
        /// <param name="billingProfileDisplayName"> The name of the billing profile. </param>
        /// <param name="billingProfileId"> The fully qualified ID that uniquely identifies a billing profile. </param>
        /// <param name="billingProfileSpendingLimit"> The billing profile spending limit. </param>
        /// <param name="billingProfileSpendingLimitDetails"> The details of billing profile spending limit. </param>
        /// <param name="billingProfileStatus"> The status of the billing profile. </param>
        /// <param name="billingProfileStatusReasonCode"> Reason for the specified billing profile status. </param>
        /// <param name="billingProfilePaymentMethodFamily"> The payment method family of the primary payment method for the billing profile. </param>
        /// <param name="billingProfilePaymentMethodType"> The payment method type of the primary payment method for the billing profile. </param>
        /// <param name="billingTenantId"> The Azure AD tenant ID of the billing account for the subscription. </param>
        /// <param name="costCenter"> The cost center applied to the subscription. Available for agreement type Microsoft Customer Agreement and Microsoft Partner Agreement. This property can be updated via patch. </param>
        /// <param name="customerDisplayName"> The name of the customer. </param>
        /// <param name="customerId"> The fully qualified ID that uniquely identifies a customer. </param>
        /// <param name="customerStatus"> Identifies the status of an customer. This is an upcoming property that will be populated in the future. </param>
        /// <param name="invoiceSectionDisplayName"> The name of the invoice section. </param>
        /// <param name="invoiceSectionId"> The fully qualified ID that uniquely identifies an invoice section. </param>
        /// <param name="invoiceSectionStatus"> Identifies the status of an invoice section. </param>
        /// <param name="invoiceSectionStatusReasonCode"> Reason for the specified invoice section status. </param>
        /// <param name="isTransitionedBillingAccount"> Specifies if the billing account for the subscription is transitioned from a Microsoft Online Service Program to a Microsoft Customer Agreement (MCA) account. Will be present and value will be true if its a transitioned billing account. </param>
        /// <param name="skuDescription"> The sku description. </param>
        /// <param name="skuId"> The ID that uniquely identifies a sku. </param>
        /// <param name="subscriptionBillingStatus"> The subscription status. </param>
        /// <param name="subscriptionBillingStatusDetails"> The reason codes for the subscription status. </param>
        /// <param name="subscriptionBillingType"> The type of billing subscription. </param>
        /// <param name="subscriptionServiceUsageAddress"> The address of the individual or organization where service subscription is being used. Available for agreement type Microsoft Online Services Program. This property can be updated via patch. </param>
        /// <param name="subscriptionWorkloadType"> The Azure workload type of the subscription. </param>
        /// <param name="enrollmentDetails"> The enrollment details for the subscription. Available for billing accounts with agreement type Enterprise Agreement. </param>
        /// <param name="isAccountAdmin"> Indicates whether user is the account admin. </param>
        /// <param name="productId"> The ID that uniquely identifies a product. </param>
        /// <param name="productName"> The ID that uniquely identifies a product. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingPropertyProperties(BillingAgreementType? billingAccountAgreementType, string billingAccountDisplayName, ResourceIdentifier billingAccountId, string accountAdminNotificationEmailAddress, string billingAccountSoldToCountry, BillingAccountStatus? billingAccountStatus, BillingAccountStatusReasonCode? billingAccountStatusReasonCode, BillingAccountType? billingAccountType, BillingAccountSubType? billingAccountSubType, string billingCurrency, string billingProfileDisplayName, ResourceIdentifier billingProfileId, BillingSpendingLimit? billingProfileSpendingLimit, IReadOnlyList<SpendingLimitDetails> billingProfileSpendingLimitDetails, BillingProfileStatus? billingProfileStatus, BillingProfileStatusReasonCode? billingProfileStatusReasonCode, PaymentMethodFamily? billingProfilePaymentMethodFamily, string billingProfilePaymentMethodType, Guid? billingTenantId, string costCenter, string customerDisplayName, ResourceIdentifier customerId, BillingCustomerStatus? customerStatus, string invoiceSectionDisplayName, ResourceIdentifier invoiceSectionId, InvoiceSectionState? invoiceSectionStatus, InvoiceSectionStateReasonCode? invoiceSectionStatusReasonCode, bool? isTransitionedBillingAccount, string skuDescription, string skuId, BillingSubscriptionStatus? subscriptionBillingStatus, IReadOnlyList<BillingSubscriptionStatusDetails> subscriptionBillingStatusDetails, SubscriptionBillingType? subscriptionBillingType, BillingAddressDetails subscriptionServiceUsageAddress, SubscriptionWorkloadType? subscriptionWorkloadType, SubscriptionEnrollmentDetails enrollmentDetails, bool? isAccountAdmin, string productId, string productName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BillingAccountAgreementType = billingAccountAgreementType;
            BillingAccountDisplayName = billingAccountDisplayName;
            BillingAccountId = billingAccountId;
            AccountAdminNotificationEmailAddress = accountAdminNotificationEmailAddress;
            BillingAccountSoldToCountry = billingAccountSoldToCountry;
            BillingAccountStatus = billingAccountStatus;
            BillingAccountStatusReasonCode = billingAccountStatusReasonCode;
            BillingAccountType = billingAccountType;
            BillingAccountSubType = billingAccountSubType;
            BillingCurrency = billingCurrency;
            BillingProfileDisplayName = billingProfileDisplayName;
            BillingProfileId = billingProfileId;
            BillingProfileSpendingLimit = billingProfileSpendingLimit;
            BillingProfileSpendingLimitDetails = billingProfileSpendingLimitDetails;
            BillingProfileStatus = billingProfileStatus;
            BillingProfileStatusReasonCode = billingProfileStatusReasonCode;
            BillingProfilePaymentMethodFamily = billingProfilePaymentMethodFamily;
            BillingProfilePaymentMethodType = billingProfilePaymentMethodType;
            BillingTenantId = billingTenantId;
            CostCenter = costCenter;
            CustomerDisplayName = customerDisplayName;
            CustomerId = customerId;
            CustomerStatus = customerStatus;
            InvoiceSectionDisplayName = invoiceSectionDisplayName;
            InvoiceSectionId = invoiceSectionId;
            InvoiceSectionStatus = invoiceSectionStatus;
            InvoiceSectionStatusReasonCode = invoiceSectionStatusReasonCode;
            IsTransitionedBillingAccount = isTransitionedBillingAccount;
            SkuDescription = skuDescription;
            SkuId = skuId;
            SubscriptionBillingStatus = subscriptionBillingStatus;
            SubscriptionBillingStatusDetails = subscriptionBillingStatusDetails;
            SubscriptionBillingType = subscriptionBillingType;
            SubscriptionServiceUsageAddress = subscriptionServiceUsageAddress;
            SubscriptionWorkloadType = subscriptionWorkloadType;
            EnrollmentDetails = enrollmentDetails;
            IsAccountAdmin = isAccountAdmin;
            ProductId = productId;
            ProductName = productName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of agreement. </summary>
        [WirePath("billingAccountAgreementType")]
        public BillingAgreementType? BillingAccountAgreementType { get; }
        /// <summary> The name of the billing account. </summary>
        [WirePath("billingAccountDisplayName")]
        public string BillingAccountDisplayName { get; }
        /// <summary> The fully qualified ID that uniquely identifies a billing account. </summary>
        [WirePath("billingAccountId")]
        public ResourceIdentifier BillingAccountId { get; }
        /// <summary> Notification email address for legacy account. Available for agreement type Microsoft Online Services Program. </summary>
        [WirePath("accountAdminNotificationEmailAddress")]
        public string AccountAdminNotificationEmailAddress { get; }
        /// <summary> The country of the individual or organization that is responsible for the billing account. </summary>
        [WirePath("billingAccountSoldToCountry")]
        public string BillingAccountSoldToCountry { get; }
        /// <summary> The current status of the billing account. </summary>
        [WirePath("billingAccountStatus")]
        public BillingAccountStatus? BillingAccountStatus { get; }
        /// <summary> Reason for the specified billing account status. </summary>
        [WirePath("billingAccountStatusReasonCode")]
        public BillingAccountStatusReasonCode? BillingAccountStatusReasonCode { get; }
        /// <summary> The type of customer. </summary>
        [WirePath("billingAccountType")]
        public BillingAccountType? BillingAccountType { get; }
        /// <summary> The tier of the account. </summary>
        [WirePath("billingAccountSubType")]
        public BillingAccountSubType? BillingAccountSubType { get; }
        /// <summary> The billing currency for the subscription. Available for billing accounts with agreement type Enterprise Agreement. </summary>
        [WirePath("billingCurrency")]
        public string BillingCurrency { get; }
        /// <summary> The name of the billing profile. </summary>
        [WirePath("billingProfileDisplayName")]
        public string BillingProfileDisplayName { get; }
        /// <summary> The fully qualified ID that uniquely identifies a billing profile. </summary>
        [WirePath("billingProfileId")]
        public ResourceIdentifier BillingProfileId { get; }
        /// <summary> The billing profile spending limit. </summary>
        [WirePath("billingProfileSpendingLimit")]
        public BillingSpendingLimit? BillingProfileSpendingLimit { get; }
        /// <summary> The details of billing profile spending limit. </summary>
        [WirePath("billingProfileSpendingLimitDetails")]
        public IReadOnlyList<SpendingLimitDetails> BillingProfileSpendingLimitDetails { get; }
        /// <summary> The status of the billing profile. </summary>
        [WirePath("billingProfileStatus")]
        public BillingProfileStatus? BillingProfileStatus { get; }
        /// <summary> Reason for the specified billing profile status. </summary>
        [WirePath("billingProfileStatusReasonCode")]
        public BillingProfileStatusReasonCode? BillingProfileStatusReasonCode { get; }
        /// <summary> The payment method family of the primary payment method for the billing profile. </summary>
        [WirePath("billingProfilePaymentMethodFamily")]
        public PaymentMethodFamily? BillingProfilePaymentMethodFamily { get; }
        /// <summary> The payment method type of the primary payment method for the billing profile. </summary>
        [WirePath("billingProfilePaymentMethodType")]
        public string BillingProfilePaymentMethodType { get; }
        /// <summary> The Azure AD tenant ID of the billing account for the subscription. </summary>
        [WirePath("billingTenantId")]
        public Guid? BillingTenantId { get; }
        /// <summary> The cost center applied to the subscription. Available for agreement type Microsoft Customer Agreement and Microsoft Partner Agreement. This property can be updated via patch. </summary>
        [WirePath("costCenter")]
        public string CostCenter { get; set; }
        /// <summary> The name of the customer. </summary>
        [WirePath("customerDisplayName")]
        public string CustomerDisplayName { get; }
        /// <summary> The fully qualified ID that uniquely identifies a customer. </summary>
        [WirePath("customerId")]
        public ResourceIdentifier CustomerId { get; }
        /// <summary> Identifies the status of an customer. This is an upcoming property that will be populated in the future. </summary>
        [WirePath("customerStatus")]
        public BillingCustomerStatus? CustomerStatus { get; }
        /// <summary> The name of the invoice section. </summary>
        [WirePath("invoiceSectionDisplayName")]
        public string InvoiceSectionDisplayName { get; }
        /// <summary> The fully qualified ID that uniquely identifies an invoice section. </summary>
        [WirePath("invoiceSectionId")]
        public ResourceIdentifier InvoiceSectionId { get; }
        /// <summary> Identifies the status of an invoice section. </summary>
        [WirePath("invoiceSectionStatus")]
        public InvoiceSectionState? InvoiceSectionStatus { get; }
        /// <summary> Reason for the specified invoice section status. </summary>
        [WirePath("invoiceSectionStatusReasonCode")]
        public InvoiceSectionStateReasonCode? InvoiceSectionStatusReasonCode { get; }
        /// <summary> Specifies if the billing account for the subscription is transitioned from a Microsoft Online Service Program to a Microsoft Customer Agreement (MCA) account. Will be present and value will be true if its a transitioned billing account. </summary>
        [WirePath("isTransitionedBillingAccount")]
        public bool? IsTransitionedBillingAccount { get; }
        /// <summary> The sku description. </summary>
        [WirePath("skuDescription")]
        public string SkuDescription { get; }
        /// <summary> The ID that uniquely identifies a sku. </summary>
        [WirePath("skuId")]
        public string SkuId { get; }
        /// <summary> The subscription status. </summary>
        [WirePath("subscriptionBillingStatus")]
        public BillingSubscriptionStatus? SubscriptionBillingStatus { get; }
        /// <summary> The reason codes for the subscription status. </summary>
        [WirePath("subscriptionBillingStatusDetails")]
        public IReadOnlyList<BillingSubscriptionStatusDetails> SubscriptionBillingStatusDetails { get; }
        /// <summary> The type of billing subscription. </summary>
        [WirePath("subscriptionBillingType")]
        public SubscriptionBillingType? SubscriptionBillingType { get; }
        /// <summary> The address of the individual or organization where service subscription is being used. Available for agreement type Microsoft Online Services Program. This property can be updated via patch. </summary>
        [WirePath("subscriptionServiceUsageAddress")]
        public BillingAddressDetails SubscriptionServiceUsageAddress { get; set; }
        /// <summary> The Azure workload type of the subscription. </summary>
        [WirePath("subscriptionWorkloadType")]
        public SubscriptionWorkloadType? SubscriptionWorkloadType { get; }
        /// <summary> The enrollment details for the subscription. Available for billing accounts with agreement type Enterprise Agreement. </summary>
        [WirePath("enrollmentDetails")]
        public SubscriptionEnrollmentDetails EnrollmentDetails { get; set; }
        /// <summary> Indicates whether user is the account admin. </summary>
        [WirePath("isAccountAdmin")]
        public bool? IsAccountAdmin { get; }
        /// <summary> The ID that uniquely identifies a product. </summary>
        [WirePath("productId")]
        public string ProductId { get; }
        /// <summary> The ID that uniquely identifies a product. </summary>
        [WirePath("productName")]
        public string ProductName { get; }
    }
}
