// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Reason for the specified billing profile status. </summary>
    public readonly partial struct BillingProfileStatusReasonCode : IEquatable<BillingProfileStatusReasonCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingProfileStatusReasonCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingProfileStatusReasonCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string PastDueValue = "PastDue";
        private const string UnusualActivityValue = "UnusualActivity";
        private const string SpendingLimitReachedValue = "SpendingLimitReached";
        private const string SpendingLimitExpiredValue = "SpendingLimitExpired";

        /// <summary> Other. </summary>
        public static BillingProfileStatusReasonCode Other { get; } = new BillingProfileStatusReasonCode(OtherValue);
        /// <summary> PastDue. </summary>
        public static BillingProfileStatusReasonCode PastDue { get; } = new BillingProfileStatusReasonCode(PastDueValue);
        /// <summary> UnusualActivity. </summary>
        public static BillingProfileStatusReasonCode UnusualActivity { get; } = new BillingProfileStatusReasonCode(UnusualActivityValue);
        /// <summary> SpendingLimitReached. </summary>
        public static BillingProfileStatusReasonCode SpendingLimitReached { get; } = new BillingProfileStatusReasonCode(SpendingLimitReachedValue);
        /// <summary> SpendingLimitExpired. </summary>
        public static BillingProfileStatusReasonCode SpendingLimitExpired { get; } = new BillingProfileStatusReasonCode(SpendingLimitExpiredValue);
        /// <summary> Determines if two <see cref="BillingProfileStatusReasonCode"/> values are the same. </summary>
        public static bool operator ==(BillingProfileStatusReasonCode left, BillingProfileStatusReasonCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingProfileStatusReasonCode"/> values are not the same. </summary>
        public static bool operator !=(BillingProfileStatusReasonCode left, BillingProfileStatusReasonCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingProfileStatusReasonCode"/>. </summary>
        public static implicit operator BillingProfileStatusReasonCode(string value) => new BillingProfileStatusReasonCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingProfileStatusReasonCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingProfileStatusReasonCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
