// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> A billing profile. </summary>
    public partial class BillingProfileProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingProfileProperties"/>. </summary>
        public BillingProfileProperties()
        {
            EnabledAzurePlans = new ChangeTrackingList<BillingAzurePlan>();
            InvoiceRecipients = new ChangeTrackingList<string>();
            SpendingLimitDetails = new ChangeTrackingList<SpendingLimitDetails>();
            Tags = new ChangeTrackingDictionary<string, string>();
            TargetClouds = new ChangeTrackingList<string>();
            OtherPaymentTerms = new ChangeTrackingList<BillingPaymentTerm>();
        }

        /// <summary> Initializes a new instance of <see cref="BillingProfileProperties"/>. </summary>
        /// <param name="provisioningState"> The provisioning state of the resource during a long-running operation. </param>
        /// <param name="billingRelationshipType"> Identifies the billing relationship represented by the billing profile. The billing relationship may be between Microsoft, the customer, and/or a third-party. </param>
        /// <param name="billTo"> Billing address. </param>
        /// <param name="currency"> The currency in which the charges for the billing profile are billed. </param>
        /// <param name="displayName"> The name of the billing profile. </param>
        /// <param name="enabledAzurePlans"> Information about the enabled azure plans. </param>
        /// <param name="hasReadAccess"> Indicates whether user has read access to the billing profile. </param>
        /// <param name="indirectRelationshipInfo"> Identifies the billing profile that is linked to another billing profile in indirect purchase motion. </param>
        /// <param name="invoiceDay"> The day of the month when the invoice for the billing profile is generated. </param>
        /// <param name="isInvoiceEmailOptIn"> Flag controlling whether the invoices for the billing profile are sent through email. </param>
        /// <param name="invoiceRecipients"> The list of email addresses to receive invoices by email for the billing profile. </param>
        /// <param name="poNumber"> The default purchase order number that will appear on the invoices generated for the billing profile. </param>
        /// <param name="shipTo"> The default address where the products are shipped, or the services are being used. If a ship to is not specified for a product or a subscription, then this address will be used. </param>
        /// <param name="soldTo"> The address of the individual or organization that is responsible for the billing account. </param>
        /// <param name="spendingLimit"> The billing profile spending limit. </param>
        /// <param name="spendingLimitDetails"> The details of billing profile spending limit. </param>
        /// <param name="status"> The status of the billing profile. </param>
        /// <param name="statusReasonCode"> Reason for the specified billing profile status. </param>
        /// <param name="systemId"> The system generated unique identifier for a billing profile. </param>
        /// <param name="tags"> Dictionary of metadata associated with the resource. Maximum key/value length supported of 256 characters. Keys/value should not empty value nor null. Keys can not contain &lt; &gt; % &amp; \ ? /. </param>
        /// <param name="targetClouds"> Identifies the cloud environments that are associated with a billing profile. This is a system managed optional field and gets updated as the billing profile gets associated with accounts in various clouds. </param>
        /// <param name="currentPaymentTerm"> The current payment term of the billing profile. </param>
        /// <param name="otherPaymentTerms"> The other payment terms of the billing profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingProfileProperties(BillingProvisioningState? provisioningState, BillingRelationshipType? billingRelationshipType, BillingAddressDetails billTo, string currency, string displayName, IList<BillingAzurePlan> enabledAzurePlans, bool? hasReadAccess, IndirectRelationshipInfo indirectRelationshipInfo, int? invoiceDay, bool? isInvoiceEmailOptIn, IList<string> invoiceRecipients, string poNumber, BillingAddressDetails shipTo, BillingAddressDetails soldTo, BillingSpendingLimit? spendingLimit, IReadOnlyList<SpendingLimitDetails> spendingLimitDetails, BillingProfileStatus? status, BillingProfileStatusReasonCode? statusReasonCode, string systemId, IDictionary<string, string> tags, IReadOnlyList<string> targetClouds, BillingPaymentTerm currentPaymentTerm, IReadOnlyList<BillingPaymentTerm> otherPaymentTerms, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            BillingRelationshipType = billingRelationshipType;
            BillTo = billTo;
            Currency = currency;
            DisplayName = displayName;
            EnabledAzurePlans = enabledAzurePlans;
            HasReadAccess = hasReadAccess;
            IndirectRelationshipInfo = indirectRelationshipInfo;
            InvoiceDay = invoiceDay;
            IsInvoiceEmailOptIn = isInvoiceEmailOptIn;
            InvoiceRecipients = invoiceRecipients;
            PoNumber = poNumber;
            ShipTo = shipTo;
            SoldTo = soldTo;
            SpendingLimit = spendingLimit;
            SpendingLimitDetails = spendingLimitDetails;
            Status = status;
            StatusReasonCode = statusReasonCode;
            SystemId = systemId;
            Tags = tags;
            TargetClouds = targetClouds;
            CurrentPaymentTerm = currentPaymentTerm;
            OtherPaymentTerms = otherPaymentTerms;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The provisioning state of the resource during a long-running operation. </summary>
        [WirePath("provisioningState")]
        public BillingProvisioningState? ProvisioningState { get; }
        /// <summary> Identifies the billing relationship represented by the billing profile. The billing relationship may be between Microsoft, the customer, and/or a third-party. </summary>
        [WirePath("billingRelationshipType")]
        public BillingRelationshipType? BillingRelationshipType { get; }
        /// <summary> Billing address. </summary>
        [WirePath("billTo")]
        public BillingAddressDetails BillTo { get; set; }
        /// <summary> The currency in which the charges for the billing profile are billed. </summary>
        [WirePath("currency")]
        public string Currency { get; }
        /// <summary> The name of the billing profile. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; set; }
        /// <summary> Information about the enabled azure plans. </summary>
        [WirePath("enabledAzurePlans")]
        public IList<BillingAzurePlan> EnabledAzurePlans { get; }
        /// <summary> Indicates whether user has read access to the billing profile. </summary>
        [WirePath("hasReadAccess")]
        public bool? HasReadAccess { get; }
        /// <summary> Identifies the billing profile that is linked to another billing profile in indirect purchase motion. </summary>
        [WirePath("indirectRelationshipInfo")]
        public IndirectRelationshipInfo IndirectRelationshipInfo { get; set; }
        /// <summary> The day of the month when the invoice for the billing profile is generated. </summary>
        [WirePath("invoiceDay")]
        public int? InvoiceDay { get; }
        /// <summary> Flag controlling whether the invoices for the billing profile are sent through email. </summary>
        [WirePath("invoiceEmailOptIn")]
        public bool? IsInvoiceEmailOptIn { get; set; }
        /// <summary> The list of email addresses to receive invoices by email for the billing profile. </summary>
        [WirePath("invoiceRecipients")]
        public IList<string> InvoiceRecipients { get; }
        /// <summary> The default purchase order number that will appear on the invoices generated for the billing profile. </summary>
        [WirePath("poNumber")]
        public string PoNumber { get; set; }
        /// <summary> The default address where the products are shipped, or the services are being used. If a ship to is not specified for a product or a subscription, then this address will be used. </summary>
        [WirePath("shipTo")]
        public BillingAddressDetails ShipTo { get; set; }
        /// <summary> The address of the individual or organization that is responsible for the billing account. </summary>
        [WirePath("soldTo")]
        public BillingAddressDetails SoldTo { get; set; }
        /// <summary> The billing profile spending limit. </summary>
        [WirePath("spendingLimit")]
        public BillingSpendingLimit? SpendingLimit { get; }
        /// <summary> The details of billing profile spending limit. </summary>
        [WirePath("spendingLimitDetails")]
        public IReadOnlyList<SpendingLimitDetails> SpendingLimitDetails { get; }
        /// <summary> The status of the billing profile. </summary>
        [WirePath("status")]
        public BillingProfileStatus? Status { get; }
        /// <summary> Reason for the specified billing profile status. </summary>
        [WirePath("statusReasonCode")]
        public BillingProfileStatusReasonCode? StatusReasonCode { get; }
        /// <summary> The system generated unique identifier for a billing profile. </summary>
        [WirePath("systemId")]
        public string SystemId { get; }
        /// <summary> Dictionary of metadata associated with the resource. Maximum key/value length supported of 256 characters. Keys/value should not empty value nor null. Keys can not contain &lt; &gt; % &amp; \ ? /. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
        /// <summary> Identifies the cloud environments that are associated with a billing profile. This is a system managed optional field and gets updated as the billing profile gets associated with accounts in various clouds. </summary>
        [WirePath("targetClouds")]
        public IReadOnlyList<string> TargetClouds { get; }
        /// <summary> The current payment term of the billing profile. </summary>
        [WirePath("currentPaymentTerm")]
        public BillingPaymentTerm CurrentPaymentTerm { get; set; }
        /// <summary> The other payment terms of the billing profile. </summary>
        [WirePath("otherPaymentTerms")]
        public IReadOnlyList<BillingPaymentTerm> OtherPaymentTerms { get; }
    }
}
