// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class BillingProfileProperties : IUtf8JsonSerializable, IJsonModel<BillingProfileProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BillingProfileProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BillingProfileProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingProfileProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingProfileProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(BillingRelationshipType))
            {
                writer.WritePropertyName("billingRelationshipType"u8);
                writer.WriteStringValue(BillingRelationshipType.Value.ToString());
            }
            if (Optional.IsDefined(BillTo))
            {
                writer.WritePropertyName("billTo"u8);
                writer.WriteObjectValue(BillTo, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Currency))
            {
                writer.WritePropertyName("currency"u8);
                writer.WriteStringValue(Currency);
            }
            if (Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (Optional.IsCollectionDefined(EnabledAzurePlans))
            {
                writer.WritePropertyName("enabledAzurePlans"u8);
                writer.WriteStartArray();
                foreach (var item in EnabledAzurePlans)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(HasReadAccess))
            {
                writer.WritePropertyName("hasReadAccess"u8);
                writer.WriteBooleanValue(HasReadAccess.Value);
            }
            if (Optional.IsDefined(IndirectRelationshipInfo))
            {
                writer.WritePropertyName("indirectRelationshipInfo"u8);
                writer.WriteObjectValue(IndirectRelationshipInfo, options);
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceDay))
            {
                writer.WritePropertyName("invoiceDay"u8);
                writer.WriteNumberValue(InvoiceDay.Value);
            }
            if (Optional.IsDefined(IsInvoiceEmailOptIn))
            {
                writer.WritePropertyName("invoiceEmailOptIn"u8);
                writer.WriteBooleanValue(IsInvoiceEmailOptIn.Value);
            }
            if (Optional.IsCollectionDefined(InvoiceRecipients))
            {
                writer.WritePropertyName("invoiceRecipients"u8);
                writer.WriteStartArray();
                foreach (var item in InvoiceRecipients)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PoNumber))
            {
                writer.WritePropertyName("poNumber"u8);
                writer.WriteStringValue(PoNumber);
            }
            if (Optional.IsDefined(ShipTo))
            {
                writer.WritePropertyName("shipTo"u8);
                writer.WriteObjectValue(ShipTo, options);
            }
            if (Optional.IsDefined(SoldTo))
            {
                writer.WritePropertyName("soldTo"u8);
                writer.WriteObjectValue(SoldTo, options);
            }
            if (options.Format != "W" && Optional.IsDefined(SpendingLimit))
            {
                writer.WritePropertyName("spendingLimit"u8);
                writer.WriteStringValue(SpendingLimit.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SpendingLimitDetails))
            {
                writer.WritePropertyName("spendingLimitDetails"u8);
                writer.WriteStartArray();
                foreach (var item in SpendingLimitDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StatusReasonCode))
            {
                writer.WritePropertyName("statusReasonCode"u8);
                writer.WriteStringValue(StatusReasonCode.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(SystemId))
            {
                writer.WritePropertyName("systemId"u8);
                writer.WriteStringValue(SystemId);
            }
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(TargetClouds))
            {
                writer.WritePropertyName("targetClouds"u8);
                writer.WriteStartArray();
                foreach (var item in TargetClouds)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(CurrentPaymentTerm))
            {
                writer.WritePropertyName("currentPaymentTerm"u8);
                writer.WriteObjectValue(CurrentPaymentTerm, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(OtherPaymentTerms))
            {
                writer.WritePropertyName("otherPaymentTerms"u8);
                writer.WriteStartArray();
                foreach (var item in OtherPaymentTerms)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BillingProfileProperties IJsonModel<BillingProfileProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingProfileProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingProfileProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBillingProfileProperties(document.RootElement, options);
        }

        internal static BillingProfileProperties DeserializeBillingProfileProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BillingProvisioningState? provisioningState = default;
            BillingRelationshipType? billingRelationshipType = default;
            BillingAddressDetails billTo = default;
            string currency = default;
            string displayName = default;
            IList<BillingAzurePlan> enabledAzurePlans = default;
            bool? hasReadAccess = default;
            IndirectRelationshipInfo indirectRelationshipInfo = default;
            int? invoiceDay = default;
            bool? invoiceEmailOptIn = default;
            IList<string> invoiceRecipients = default;
            string poNumber = default;
            BillingAddressDetails shipTo = default;
            BillingAddressDetails soldTo = default;
            BillingSpendingLimit? spendingLimit = default;
            IReadOnlyList<SpendingLimitDetails> spendingLimitDetails = default;
            BillingProfileStatus? status = default;
            BillingProfileStatusReasonCode? statusReasonCode = default;
            string systemId = default;
            IDictionary<string, string> tags = default;
            IReadOnlyList<string> targetClouds = default;
            BillingPaymentTerm currentPaymentTerm = default;
            IReadOnlyList<BillingPaymentTerm> otherPaymentTerms = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new BillingProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("billingRelationshipType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    billingRelationshipType = new BillingRelationshipType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("billTo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    billTo = BillingAddressDetails.DeserializeBillingAddressDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("currency"u8))
                {
                    currency = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("enabledAzurePlans"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BillingAzurePlan> array = new List<BillingAzurePlan>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BillingAzurePlan.DeserializeBillingAzurePlan(item, options));
                    }
                    enabledAzurePlans = array;
                    continue;
                }
                if (property.NameEquals("hasReadAccess"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasReadAccess = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("indirectRelationshipInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    indirectRelationshipInfo = IndirectRelationshipInfo.DeserializeIndirectRelationshipInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("invoiceDay"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invoiceDay = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("invoiceEmailOptIn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invoiceEmailOptIn = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("invoiceRecipients"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    invoiceRecipients = array;
                    continue;
                }
                if (property.NameEquals("poNumber"u8))
                {
                    poNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("shipTo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    shipTo = BillingAddressDetails.DeserializeBillingAddressDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("soldTo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    soldTo = BillingAddressDetails.DeserializeBillingAddressDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("spendingLimit"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    spendingLimit = new BillingSpendingLimit(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("spendingLimitDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SpendingLimitDetails> array = new List<SpendingLimitDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Models.SpendingLimitDetails.DeserializeSpendingLimitDetails(item, options));
                    }
                    spendingLimitDetails = array;
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = new BillingProfileStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("statusReasonCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    statusReasonCode = new BillingProfileStatusReasonCode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemId"u8))
                {
                    systemId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("targetClouds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    targetClouds = array;
                    continue;
                }
                if (property.NameEquals("currentPaymentTerm"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    currentPaymentTerm = BillingPaymentTerm.DeserializeBillingPaymentTerm(property.Value, options);
                    continue;
                }
                if (property.NameEquals("otherPaymentTerms"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BillingPaymentTerm> array = new List<BillingPaymentTerm>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BillingPaymentTerm.DeserializeBillingPaymentTerm(item, options));
                    }
                    otherPaymentTerms = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BillingProfileProperties(
                provisioningState,
                billingRelationshipType,
                billTo,
                currency,
                displayName,
                enabledAzurePlans ?? new ChangeTrackingList<BillingAzurePlan>(),
                hasReadAccess,
                indirectRelationshipInfo,
                invoiceDay,
                invoiceEmailOptIn,
                invoiceRecipients ?? new ChangeTrackingList<string>(),
                poNumber,
                shipTo,
                soldTo,
                spendingLimit,
                spendingLimitDetails ?? new ChangeTrackingList<SpendingLimitDetails>(),
                status,
                statusReasonCode,
                systemId,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                targetClouds ?? new ChangeTrackingList<string>(),
                currentPaymentTerm,
                otherPaymentTerms ?? new ChangeTrackingList<BillingPaymentTerm>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("  provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingRelationshipType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billingRelationshipType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingRelationshipType))
                {
                    builder.Append("  billingRelationshipType: ");
                    builder.AppendLine($"'{BillingRelationshipType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillTo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billTo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillTo))
                {
                    builder.Append("  billTo: ");
                    BicepSerializationHelpers.AppendChildObject(builder, BillTo, options, 2, false, "  billTo: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Currency), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  currency: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Currency))
                {
                    builder.Append("  currency: ");
                    if (Currency.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Currency}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Currency}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  displayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisplayName))
                {
                    builder.Append("  displayName: ");
                    if (DisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnabledAzurePlans), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enabledAzurePlans: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(EnabledAzurePlans))
                {
                    if (EnabledAzurePlans.Any())
                    {
                        builder.Append("  enabledAzurePlans: ");
                        builder.AppendLine("[");
                        foreach (var item in EnabledAzurePlans)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  enabledAzurePlans: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HasReadAccess), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  hasReadAccess: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HasReadAccess))
                {
                    builder.Append("  hasReadAccess: ");
                    var boolValue = HasReadAccess.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IndirectRelationshipInfo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  indirectRelationshipInfo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IndirectRelationshipInfo))
                {
                    builder.Append("  indirectRelationshipInfo: ");
                    BicepSerializationHelpers.AppendChildObject(builder, IndirectRelationshipInfo, options, 2, false, "  indirectRelationshipInfo: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceDay), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoiceDay: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoiceDay))
                {
                    builder.Append("  invoiceDay: ");
                    builder.AppendLine($"{InvoiceDay.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsInvoiceEmailOptIn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoiceEmailOptIn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsInvoiceEmailOptIn))
                {
                    builder.Append("  invoiceEmailOptIn: ");
                    var boolValue = IsInvoiceEmailOptIn.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceRecipients), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoiceRecipients: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(InvoiceRecipients))
                {
                    if (InvoiceRecipients.Any())
                    {
                        builder.Append("  invoiceRecipients: ");
                        builder.AppendLine("[");
                        foreach (var item in InvoiceRecipients)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PoNumber), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  poNumber: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PoNumber))
                {
                    builder.Append("  poNumber: ");
                    if (PoNumber.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PoNumber}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PoNumber}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ShipTo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  shipTo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ShipTo))
                {
                    builder.Append("  shipTo: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ShipTo, options, 2, false, "  shipTo: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SoldTo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  soldTo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SoldTo))
                {
                    builder.Append("  soldTo: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SoldTo, options, 2, false, "  soldTo: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SpendingLimit), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  spendingLimit: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SpendingLimit))
                {
                    builder.Append("  spendingLimit: ");
                    builder.AppendLine($"'{SpendingLimit.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SpendingLimitDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  spendingLimitDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SpendingLimitDetails))
                {
                    if (SpendingLimitDetails.Any())
                    {
                        builder.Append("  spendingLimitDetails: ");
                        builder.AppendLine("[");
                        foreach (var item in SpendingLimitDetails)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  spendingLimitDetails: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("  status: ");
                    builder.AppendLine($"'{Status.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StatusReasonCode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  statusReasonCode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StatusReasonCode))
                {
                    builder.Append("  statusReasonCode: ");
                    builder.AppendLine($"'{StatusReasonCode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemId))
                {
                    builder.Append("  systemId: ");
                    if (SystemId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SystemId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SystemId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TargetClouds), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  targetClouds: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(TargetClouds))
                {
                    if (TargetClouds.Any())
                    {
                        builder.Append("  targetClouds: ");
                        builder.AppendLine("[");
                        foreach (var item in TargetClouds)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentPaymentTerm), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  currentPaymentTerm: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentPaymentTerm))
                {
                    builder.Append("  currentPaymentTerm: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CurrentPaymentTerm, options, 2, false, "  currentPaymentTerm: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OtherPaymentTerms), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  otherPaymentTerms: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(OtherPaymentTerms))
                {
                    if (OtherPaymentTerms.Any())
                    {
                        builder.Append("  otherPaymentTerms: ");
                        builder.AppendLine("[");
                        foreach (var item in OtherPaymentTerms)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  otherPaymentTerms: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<BillingProfileProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingProfileProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(BillingProfileProperties)} does not support writing '{options.Format}' format.");
            }
        }

        BillingProfileProperties IPersistableModel<BillingProfileProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingProfileProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBillingProfileProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BillingProfileProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BillingProfileProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
