// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Access Decision, specifies access is allowed or not. </summary>
    public readonly partial struct BillingProfileAccessDecision : IEquatable<BillingProfileAccessDecision>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingProfileAccessDecision"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingProfileAccessDecision(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AllowedValue = "Allowed";
        private const string NotAllowedValue = "NotAllowed";

        /// <summary> Other. </summary>
        public static BillingProfileAccessDecision Other { get; } = new BillingProfileAccessDecision(OtherValue);
        /// <summary> Allowed. </summary>
        public static BillingProfileAccessDecision Allowed { get; } = new BillingProfileAccessDecision(AllowedValue);
        /// <summary> NotAllowed. </summary>
        public static BillingProfileAccessDecision NotAllowed { get; } = new BillingProfileAccessDecision(NotAllowedValue);
        /// <summary> Determines if two <see cref="BillingProfileAccessDecision"/> values are the same. </summary>
        public static bool operator ==(BillingProfileAccessDecision left, BillingProfileAccessDecision right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingProfileAccessDecision"/> values are not the same. </summary>
        public static bool operator !=(BillingProfileAccessDecision left, BillingProfileAccessDecision right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingProfileAccessDecision"/>. </summary>
        public static implicit operator BillingProfileAccessDecision(string value) => new BillingProfileAccessDecision(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingProfileAccessDecision other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingProfileAccessDecision other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
