// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The type of product that is transferred. </summary>
    public readonly partial struct BillingProductType : IEquatable<BillingProductType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingProductType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingProductType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureSubscriptionValue = "AzureSubscription";
        private const string AzureReservationValue = "AzureReservation";
        private const string DepartmentValue = "Department";
        private const string SavingsPlanValue = "SavingsPlan";
        private const string SaasValue = "SAAS";

        /// <summary> AzureSubscription. </summary>
        public static BillingProductType AzureSubscription { get; } = new BillingProductType(AzureSubscriptionValue);
        /// <summary> AzureReservation. </summary>
        public static BillingProductType AzureReservation { get; } = new BillingProductType(AzureReservationValue);
        /// <summary> Department. </summary>
        public static BillingProductType Department { get; } = new BillingProductType(DepartmentValue);
        /// <summary> SavingsPlan. </summary>
        public static BillingProductType SavingsPlan { get; } = new BillingProductType(SavingsPlanValue);
        /// <summary> SAAS. </summary>
        public static BillingProductType Saas { get; } = new BillingProductType(SaasValue);
        /// <summary> Determines if two <see cref="BillingProductType"/> values are the same. </summary>
        public static bool operator ==(BillingProductType left, BillingProductType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingProductType"/> values are not the same. </summary>
        public static bool operator !=(BillingProductType left, BillingProductType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingProductType"/>. </summary>
        public static implicit operator BillingProductType(string value) => new BillingProductType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingProductType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingProductType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
