// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The status of a transfer. </summary>
    public readonly partial struct BillingProductTransferStatus : IEquatable<BillingProductTransferStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingProductTransferStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingProductTransferStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string InProgressValue = "InProgress";
        private const string CompletedValue = "Completed";
        private const string FailedValue = "Failed";

        /// <summary> NotStarted. </summary>
        public static BillingProductTransferStatus NotStarted { get; } = new BillingProductTransferStatus(NotStartedValue);
        /// <summary> InProgress. </summary>
        public static BillingProductTransferStatus InProgress { get; } = new BillingProductTransferStatus(InProgressValue);
        /// <summary> Completed. </summary>
        public static BillingProductTransferStatus Completed { get; } = new BillingProductTransferStatus(CompletedValue);
        /// <summary> Failed. </summary>
        public static BillingProductTransferStatus Failed { get; } = new BillingProductTransferStatus(FailedValue);
        /// <summary> Determines if two <see cref="BillingProductTransferStatus"/> values are the same. </summary>
        public static bool operator ==(BillingProductTransferStatus left, BillingProductTransferStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingProductTransferStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingProductTransferStatus left, BillingProductTransferStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingProductTransferStatus"/>. </summary>
        public static implicit operator BillingProductTransferStatus(string value) => new BillingProductTransferStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingProductTransferStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingProductTransferStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
