// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The status of the product. </summary>
    public readonly partial struct BillingProductStatus : IEquatable<BillingProductStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingProductStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingProductStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string ActiveValue = "Active";
        private const string DisabledValue = "Disabled";
        private const string DeletedValue = "Deleted";
        private const string PastDueValue = "PastDue";
        private const string ExpiringValue = "Expiring";
        private const string ExpiredValue = "Expired";
        private const string AutoRenewValue = "AutoRenew";
        private const string CanceledValue = "Canceled";
        private const string SuspendedValue = "Suspended";

        /// <summary> Other. </summary>
        public static BillingProductStatus Other { get; } = new BillingProductStatus(OtherValue);
        /// <summary> Active. </summary>
        public static BillingProductStatus Active { get; } = new BillingProductStatus(ActiveValue);
        /// <summary> Disabled. </summary>
        public static BillingProductStatus Disabled { get; } = new BillingProductStatus(DisabledValue);
        /// <summary> Deleted. </summary>
        public static BillingProductStatus Deleted { get; } = new BillingProductStatus(DeletedValue);
        /// <summary> PastDue. </summary>
        public static BillingProductStatus PastDue { get; } = new BillingProductStatus(PastDueValue);
        /// <summary> Expiring. </summary>
        public static BillingProductStatus Expiring { get; } = new BillingProductStatus(ExpiringValue);
        /// <summary> Expired. </summary>
        public static BillingProductStatus Expired { get; } = new BillingProductStatus(ExpiredValue);
        /// <summary> AutoRenew. </summary>
        public static BillingProductStatus AutoRenew { get; } = new BillingProductStatus(AutoRenewValue);
        /// <summary> Canceled. </summary>
        public static BillingProductStatus Canceled { get; } = new BillingProductStatus(CanceledValue);
        /// <summary> Suspended. </summary>
        public static BillingProductStatus Suspended { get; } = new BillingProductStatus(SuspendedValue);
        /// <summary> Determines if two <see cref="BillingProductStatus"/> values are the same. </summary>
        public static bool operator ==(BillingProductStatus left, BillingProductStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingProductStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingProductStatus left, BillingProductStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingProductStatus"/>. </summary>
        public static implicit operator BillingProductStatus(string value) => new BillingProductStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingProductStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingProductStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
