// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> A product. </summary>
    public partial class BillingProductProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingProductProperties"/>. </summary>
        public BillingProductProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingProductProperties"/>. </summary>
        /// <param name="autoRenew"> Indicates whether auto renewal is turned on or off for a product. </param>
        /// <param name="availabilityId"> The availability of the product. </param>
        /// <param name="billingFrequency"> The frequency at which the product will be billed. </param>
        /// <param name="billingProfileId"> The ID of the billing profile to which the product is billed. </param>
        /// <param name="billingProfileDisplayName"> The name of the billing profile to which the product is billed. </param>
        /// <param name="customerId"> The ID of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner Agreement billing account. </param>
        /// <param name="customerDisplayName"> The name of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner Agreement billing account. </param>
        /// <param name="displayName"> The display name of the product. </param>
        /// <param name="endDate"> The date when the product will be renewed or canceled. </param>
        /// <param name="invoiceSectionId"> The ID of the invoice section to which the product is billed. </param>
        /// <param name="invoiceSectionDisplayName"> The name of the invoice section to which the product is billed. </param>
        /// <param name="lastCharge"> The last month charges. </param>
        /// <param name="lastChargeDate"> The date of the last charge. </param>
        /// <param name="productType"> The description of the type of product. </param>
        /// <param name="productTypeId"> The ID of the type of product. </param>
        /// <param name="skuId"> The sku ID of the product. </param>
        /// <param name="skuDescription"> The sku description of the product. </param>
        /// <param name="purchaseDate"> The date when the product was purchased. </param>
        /// <param name="quantity"> The quantity purchased for the product. </param>
        /// <param name="status"> The status of the product. </param>
        /// <param name="tenantId"> The id of the tenant in which the product is used. </param>
        /// <param name="reseller"> Reseller for this product. The fields is not available for Microsoft Partner Agreement products. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingProductProperties(BillingSubscriptionAutoRenewState? autoRenew, string availabilityId, string billingFrequency, ResourceIdentifier billingProfileId, string billingProfileDisplayName, ResourceIdentifier customerId, string customerDisplayName, string displayName, string endDate, ResourceIdentifier invoiceSectionId, string invoiceSectionDisplayName, BillingAmount lastCharge, string lastChargeDate, string productType, string productTypeId, string skuId, string skuDescription, string purchaseDate, long? quantity, BillingProductStatus? status, Guid? tenantId, BillingAmount reseller, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AutoRenew = autoRenew;
            AvailabilityId = availabilityId;
            BillingFrequency = billingFrequency;
            BillingProfileId = billingProfileId;
            BillingProfileDisplayName = billingProfileDisplayName;
            CustomerId = customerId;
            CustomerDisplayName = customerDisplayName;
            DisplayName = displayName;
            EndDate = endDate;
            InvoiceSectionId = invoiceSectionId;
            InvoiceSectionDisplayName = invoiceSectionDisplayName;
            LastCharge = lastCharge;
            LastChargeDate = lastChargeDate;
            ProductType = productType;
            ProductTypeId = productTypeId;
            SkuId = skuId;
            SkuDescription = skuDescription;
            PurchaseDate = purchaseDate;
            Quantity = quantity;
            Status = status;
            TenantId = tenantId;
            Reseller = reseller;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Indicates whether auto renewal is turned on or off for a product. </summary>
        [WirePath("autoRenew")]
        public BillingSubscriptionAutoRenewState? AutoRenew { get; set; }
        /// <summary> The availability of the product. </summary>
        [WirePath("availabilityId")]
        public string AvailabilityId { get; }
        /// <summary> The frequency at which the product will be billed. </summary>
        [WirePath("billingFrequency")]
        public string BillingFrequency { get; }
        /// <summary> The ID of the billing profile to which the product is billed. </summary>
        [WirePath("billingProfileId")]
        public ResourceIdentifier BillingProfileId { get; }
        /// <summary> The name of the billing profile to which the product is billed. </summary>
        [WirePath("billingProfileDisplayName")]
        public string BillingProfileDisplayName { get; }
        /// <summary> The ID of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner Agreement billing account. </summary>
        [WirePath("customerId")]
        public ResourceIdentifier CustomerId { get; }
        /// <summary> The name of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner Agreement billing account. </summary>
        [WirePath("customerDisplayName")]
        public string CustomerDisplayName { get; }
        /// <summary> The display name of the product. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; }
        /// <summary> The date when the product will be renewed or canceled. </summary>
        [WirePath("endDate")]
        public string EndDate { get; }
        /// <summary> The ID of the invoice section to which the product is billed. </summary>
        [WirePath("invoiceSectionId")]
        public ResourceIdentifier InvoiceSectionId { get; }
        /// <summary> The name of the invoice section to which the product is billed. </summary>
        [WirePath("invoiceSectionDisplayName")]
        public string InvoiceSectionDisplayName { get; }
        /// <summary> The last month charges. </summary>
        [WirePath("lastCharge")]
        public BillingAmount LastCharge { get; }
        /// <summary> The date of the last charge. </summary>
        [WirePath("lastChargeDate")]
        public string LastChargeDate { get; }
        /// <summary> The description of the type of product. </summary>
        [WirePath("productType")]
        public string ProductType { get; }
        /// <summary> The ID of the type of product. </summary>
        [WirePath("productTypeId")]
        public string ProductTypeId { get; }
        /// <summary> The sku ID of the product. </summary>
        [WirePath("skuId")]
        public string SkuId { get; }
        /// <summary> The sku description of the product. </summary>
        [WirePath("skuDescription")]
        public string SkuDescription { get; }
        /// <summary> The date when the product was purchased. </summary>
        [WirePath("purchaseDate")]
        public string PurchaseDate { get; }
        /// <summary> The quantity purchased for the product. </summary>
        [WirePath("quantity")]
        public long? Quantity { get; }
        /// <summary> The status of the product. </summary>
        [WirePath("status")]
        public BillingProductStatus? Status { get; }
        /// <summary> The id of the tenant in which the product is used. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; }
        /// <summary> Reseller for this product. The fields is not available for Microsoft Partner Agreement products. </summary>
        [WirePath("reseller")]
        public BillingAmount Reseller { get; }
    }
}
