// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The type of a role Assignment. </summary>
    public readonly partial struct BillingPrincipalType : IEquatable<BillingPrincipalType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingPrincipalType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingPrincipalType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string NoneValue = "None";
        private const string UserValue = "User";
        private const string GroupValue = "Group";
        private const string DirectoryRoleValue = "DirectoryRole";
        private const string ServicePrincipalValue = "ServicePrincipal";
        private const string EveryoneValue = "Everyone";

        /// <summary> Unknown. </summary>
        public static BillingPrincipalType Unknown { get; } = new BillingPrincipalType(UnknownValue);
        /// <summary> None. </summary>
        public static BillingPrincipalType None { get; } = new BillingPrincipalType(NoneValue);
        /// <summary> User. </summary>
        public static BillingPrincipalType User { get; } = new BillingPrincipalType(UserValue);
        /// <summary> Group. </summary>
        public static BillingPrincipalType Group { get; } = new BillingPrincipalType(GroupValue);
        /// <summary> DirectoryRole. </summary>
        public static BillingPrincipalType DirectoryRole { get; } = new BillingPrincipalType(DirectoryRoleValue);
        /// <summary> ServicePrincipal. </summary>
        public static BillingPrincipalType ServicePrincipal { get; } = new BillingPrincipalType(ServicePrincipalValue);
        /// <summary> Everyone. </summary>
        public static BillingPrincipalType Everyone { get; } = new BillingPrincipalType(EveryoneValue);
        /// <summary> Determines if two <see cref="BillingPrincipalType"/> values are the same. </summary>
        public static bool operator ==(BillingPrincipalType left, BillingPrincipalType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingPrincipalType"/> values are not the same. </summary>
        public static bool operator !=(BillingPrincipalType left, BillingPrincipalType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingPrincipalType"/>. </summary>
        public static implicit operator BillingPrincipalType(string value) => new BillingPrincipalType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingPrincipalType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingPrincipalType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
