// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The summary of the policy. </summary>
    public partial class BillingPolicySummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingPolicySummary"/>. </summary>
        public BillingPolicySummary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingPolicySummary"/>. </summary>
        /// <param name="name"> The name of the policy. </param>
        /// <param name="value"> The value of the policy. </param>
        /// <param name="policyType"> The type of the policy. </param>
        /// <param name="scope"> The scope at which the policy is defined. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingPolicySummary(string name, string value, BillingPolicyType? policyType, string scope, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Value = value;
            PolicyType = policyType;
            Scope = scope;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the policy. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The value of the policy. </summary>
        [WirePath("value")]
        public string Value { get; set; }
        /// <summary> The type of the policy. </summary>
        [WirePath("policyType")]
        public BillingPolicyType? PolicyType { get; set; }
        /// <summary> The scope at which the policy is defined. </summary>
        [WirePath("scope")]
        public string Scope { get; set; }
    }
}
