// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Information about payment related to a savings plan order. </summary>
    public partial class BillingPlanPaymentDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingPlanPaymentDetail"/>. </summary>
        public BillingPlanPaymentDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingPlanPaymentDetail"/>. </summary>
        /// <param name="dueOn"> Date when the payment needs to be done. </param>
        /// <param name="paymentCompletedOn"> Date when the transaction is completed. Null when it is scheduled. </param>
        /// <param name="pricingCurrencyTotal"> Amount in pricing currency. Tax not included. </param>
        /// <param name="billingCurrencyTotal"> Amount charged in Billing currency. Tax not included. Is null for future payments. </param>
        /// <param name="status"> Describes whether the payment is completed, failed, pending, cancelled or scheduled in the future. </param>
        /// <param name="extendedStatusInfo"> Extended status information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingPlanPaymentDetail(DateTimeOffset? dueOn, DateTimeOffset? paymentCompletedOn, BillingPrice pricingCurrencyTotal, BillingPrice billingCurrencyTotal, BillingPaymentStatus? status, ExtendedStatusInfo extendedStatusInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DueOn = dueOn;
            PaymentCompletedOn = paymentCompletedOn;
            PricingCurrencyTotal = pricingCurrencyTotal;
            BillingCurrencyTotal = billingCurrencyTotal;
            Status = status;
            ExtendedStatusInfo = extendedStatusInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Date when the payment needs to be done. </summary>
        [WirePath("dueDate")]
        public DateTimeOffset? DueOn { get; set; }
        /// <summary> Date when the transaction is completed. Null when it is scheduled. </summary>
        [WirePath("paymentDate")]
        public DateTimeOffset? PaymentCompletedOn { get; set; }
        /// <summary> Amount in pricing currency. Tax not included. </summary>
        [WirePath("pricingCurrencyTotal")]
        public BillingPrice PricingCurrencyTotal { get; set; }
        /// <summary> Amount charged in Billing currency. Tax not included. Is null for future payments. </summary>
        [WirePath("billingCurrencyTotal")]
        public BillingPrice BillingCurrencyTotal { get; set; }
        /// <summary> Describes whether the payment is completed, failed, pending, cancelled or scheduled in the future. </summary>
        [WirePath("status")]
        public BillingPaymentStatus? Status { get; set; }
        /// <summary> Extended status information. </summary>
        [WirePath("extendedStatusInfo")]
        public ExtendedStatusInfo ExtendedStatusInfo { get; }
    }
}
