// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The set of allowed action and not allowed actions a caller has on a resource. </summary>
    public partial class BillingPermission
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingPermission"/>. </summary>
        internal BillingPermission()
        {
            Actions = new ChangeTrackingList<string>();
            NotActions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="BillingPermission"/>. </summary>
        /// <param name="actions"> The set of actions that the caller is allowed to perform. </param>
        /// <param name="notActions"> The set of actions that the caller is not allowed to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingPermission(IReadOnlyList<string> actions, IReadOnlyList<string> notActions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Actions = actions;
            NotActions = notActions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The set of actions that the caller is allowed to perform. </summary>
        [WirePath("actions")]
        public IReadOnlyList<string> Actions { get; }
        /// <summary> The set of actions that the caller is not allowed to perform. </summary>
        [WirePath("notActions")]
        public IReadOnlyList<string> NotActions { get; }
    }
}
