// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The state determines whether users from the associated tenant can be assigned roles for commerce activities like viewing and downloading invoices, managing payments, and making purchases. </summary>
    public readonly partial struct BillingManagementTenantState : IEquatable<BillingManagementTenantState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingManagementTenantState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingManagementTenantState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string NotAllowedValue = "NotAllowed";
        private const string ActiveValue = "Active";
        private const string RevokedValue = "Revoked";

        /// <summary> Other. </summary>
        public static BillingManagementTenantState Other { get; } = new BillingManagementTenantState(OtherValue);
        /// <summary> NotAllowed. </summary>
        public static BillingManagementTenantState NotAllowed { get; } = new BillingManagementTenantState(NotAllowedValue);
        /// <summary> Active. </summary>
        public static BillingManagementTenantState Active { get; } = new BillingManagementTenantState(ActiveValue);
        /// <summary> Revoked. </summary>
        public static BillingManagementTenantState Revoked { get; } = new BillingManagementTenantState(RevokedValue);
        /// <summary> Determines if two <see cref="BillingManagementTenantState"/> values are the same. </summary>
        public static bool operator ==(BillingManagementTenantState left, BillingManagementTenantState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingManagementTenantState"/> values are not the same. </summary>
        public static bool operator !=(BillingManagementTenantState left, BillingManagementTenantState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingManagementTenantState"/>. </summary>
        public static implicit operator BillingManagementTenantState(string value) => new BillingManagementTenantState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingManagementTenantState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingManagementTenantState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
