// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Invoice type. </summary>
    public readonly partial struct BillingInvoiceType : IEquatable<BillingInvoiceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingInvoiceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingInvoiceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AzureServicesValue = "AzureServices";
        private const string AzureMarketplaceValue = "AzureMarketplace";
        private const string AzureSupportValue = "AzureSupport";

        /// <summary> Other. </summary>
        public static BillingInvoiceType Other { get; } = new BillingInvoiceType(OtherValue);
        /// <summary> AzureServices. </summary>
        public static BillingInvoiceType AzureServices { get; } = new BillingInvoiceType(AzureServicesValue);
        /// <summary> AzureMarketplace. </summary>
        public static BillingInvoiceType AzureMarketplace { get; } = new BillingInvoiceType(AzureMarketplaceValue);
        /// <summary> AzureSupport. </summary>
        public static BillingInvoiceType AzureSupport { get; } = new BillingInvoiceType(AzureSupportValue);
        /// <summary> Determines if two <see cref="BillingInvoiceType"/> values are the same. </summary>
        public static bool operator ==(BillingInvoiceType left, BillingInvoiceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingInvoiceType"/> values are not the same. </summary>
        public static bool operator !=(BillingInvoiceType left, BillingInvoiceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingInvoiceType"/>. </summary>
        public static implicit operator BillingInvoiceType(string value) => new BillingInvoiceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingInvoiceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingInvoiceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
