// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The current status of the invoice. </summary>
    public readonly partial struct BillingInvoiceStatus : IEquatable<BillingInvoiceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingInvoiceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingInvoiceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string DueValue = "Due";
        private const string OverDueValue = "OverDue";
        private const string PaidValue = "Paid";
        private const string VoidValue = "Void";
        private const string LockedValue = "Locked";

        /// <summary> Other. </summary>
        public static BillingInvoiceStatus Other { get; } = new BillingInvoiceStatus(OtherValue);
        /// <summary> Due. </summary>
        public static BillingInvoiceStatus Due { get; } = new BillingInvoiceStatus(DueValue);
        /// <summary> OverDue. </summary>
        public static BillingInvoiceStatus OverDue { get; } = new BillingInvoiceStatus(OverDueValue);
        /// <summary> Paid. </summary>
        public static BillingInvoiceStatus Paid { get; } = new BillingInvoiceStatus(PaidValue);
        /// <summary> Void. </summary>
        public static BillingInvoiceStatus Void { get; } = new BillingInvoiceStatus(VoidValue);
        /// <summary> Locked. </summary>
        public static BillingInvoiceStatus Locked { get; } = new BillingInvoiceStatus(LockedValue);
        /// <summary> Determines if two <see cref="BillingInvoiceStatus"/> values are the same. </summary>
        public static bool operator ==(BillingInvoiceStatus left, BillingInvoiceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingInvoiceStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingInvoiceStatus left, BillingInvoiceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingInvoiceStatus"/>. </summary>
        public static implicit operator BillingInvoiceStatus(string value) => new BillingInvoiceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingInvoiceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingInvoiceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
