// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class BillingInvoiceProperties : IUtf8JsonSerializable, IJsonModel<BillingInvoiceProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BillingInvoiceProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BillingInvoiceProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingInvoiceProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingInvoiceProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(AmountDue))
            {
                writer.WritePropertyName("amountDue"u8);
                writer.WriteObjectValue(AmountDue, options);
            }
            if (options.Format != "W" && Optional.IsDefined(AzurePrepaymentApplied))
            {
                writer.WritePropertyName("azurePrepaymentApplied"u8);
                writer.WriteObjectValue(AzurePrepaymentApplied, options);
            }
            if (options.Format != "W" && Optional.IsDefined(BilledAmount))
            {
                writer.WritePropertyName("billedAmount"u8);
                writer.WriteObjectValue(BilledAmount, options);
            }
            if (options.Format != "W" && Optional.IsDefined(BilledDocumentId))
            {
                writer.WritePropertyName("billedDocumentId"u8);
                writer.WriteStringValue(BilledDocumentId);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingProfileDisplayName))
            {
                writer.WritePropertyName("billingProfileDisplayName"u8);
                writer.WriteStringValue(BillingProfileDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingProfileId))
            {
                writer.WritePropertyName("billingProfileId"u8);
                writer.WriteStringValue(BillingProfileId);
            }
            if (options.Format != "W" && Optional.IsDefined(CreditAmount))
            {
                writer.WritePropertyName("creditAmount"u8);
                writer.WriteObjectValue(CreditAmount, options);
            }
            if (options.Format != "W" && Optional.IsDefined(CreditForDocumentId))
            {
                writer.WritePropertyName("creditForDocumentId"u8);
                writer.WriteStringValue(CreditForDocumentId);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Documents))
            {
                writer.WritePropertyName("documents"u8);
                writer.WriteStartArray();
                foreach (var item in Documents)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(DocumentType))
            {
                writer.WritePropertyName("documentType"u8);
                writer.WriteStringValue(DocumentType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(DueOn))
            {
                writer.WritePropertyName("dueDate"u8);
                writer.WriteStringValue(DueOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(FailedPayments))
            {
                writer.WritePropertyName("failedPayments"u8);
                writer.WriteStartArray();
                foreach (var item in FailedPayments)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(FreeAzureCreditApplied))
            {
                writer.WritePropertyName("freeAzureCreditApplied"u8);
                writer.WriteObjectValue(FreeAzureCreditApplied, options);
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceOn))
            {
                writer.WritePropertyName("invoiceDate"u8);
                writer.WriteStringValue(InvoiceOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(InvoicePeriodEndOn))
            {
                writer.WritePropertyName("invoicePeriodEndDate"u8);
                writer.WriteStringValue(InvoicePeriodEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(InvoicePeriodStartOn))
            {
                writer.WritePropertyName("invoicePeriodStartDate"u8);
                writer.WriteStringValue(InvoicePeriodStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceType))
            {
                writer.WritePropertyName("invoiceType"u8);
                writer.WriteStringValue(InvoiceType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(IsMonthlyInvoice))
            {
                writer.WritePropertyName("isMonthlyInvoice"u8);
                writer.WriteBooleanValue(IsMonthlyInvoice.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Payments))
            {
                writer.WritePropertyName("payments"u8);
                writer.WriteStartArray();
                foreach (var item in Payments)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(PurchaseOrderNumber))
            {
                writer.WritePropertyName("purchaseOrderNumber"u8);
                writer.WriteStringValue(PurchaseOrderNumber);
            }
            if (options.Format != "W" && Optional.IsDefined(RebillDetails))
            {
                writer.WritePropertyName("rebillDetails"u8);
                writer.WriteObjectValue(RebillDetails, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionDisplayName))
            {
                writer.WritePropertyName("subscriptionDisplayName"u8);
                writer.WriteStringValue(SubscriptionDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionId))
            {
                writer.WritePropertyName("subscriptionId"u8);
                writer.WriteStringValue(SubscriptionId);
            }
            if (options.Format != "W" && Optional.IsDefined(SpecialTaxationType))
            {
                writer.WritePropertyName("specialTaxationType"u8);
                writer.WriteStringValue(SpecialTaxationType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(SubTotal))
            {
                writer.WritePropertyName("subTotal"u8);
                writer.WriteObjectValue(SubTotal, options);
            }
            if (options.Format != "W" && Optional.IsDefined(TaxAmount))
            {
                writer.WritePropertyName("taxAmount"u8);
                writer.WriteObjectValue(TaxAmount, options);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalAmount))
            {
                writer.WritePropertyName("totalAmount"u8);
                writer.WriteObjectValue(TotalAmount, options);
            }
            if (Optional.IsDefined(RefundDetails))
            {
                writer.WritePropertyName("refundDetails"u8);
                writer.WriteObjectValue(RefundDetails, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BillingInvoiceProperties IJsonModel<BillingInvoiceProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingInvoiceProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingInvoiceProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBillingInvoiceProperties(document.RootElement, options);
        }

        internal static BillingInvoiceProperties DeserializeBillingInvoiceProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BillingAmount amountDue = default;
            BillingAmount azurePrepaymentApplied = default;
            BillingAmount billedAmount = default;
            string billedDocumentId = default;
            string billingProfileDisplayName = default;
            ResourceIdentifier billingProfileId = default;
            BillingAmount creditAmount = default;
            string creditForDocumentId = default;
            IReadOnlyList<InvoiceDocument> documents = default;
            InvoiceDocumentType? documentType = default;
            DateTimeOffset? dueDate = default;
            IReadOnlyList<BillingInvoiceFailedPayment> failedPayments = default;
            BillingAmount freeAzureCreditApplied = default;
            DateTimeOffset? invoiceDate = default;
            DateTimeOffset? invoicePeriodEndDate = default;
            DateTimeOffset? invoicePeriodStartDate = default;
            BillingInvoiceType? invoiceType = default;
            bool? isMonthlyInvoice = default;
            IReadOnlyList<BillingInvoicePayment> payments = default;
            string purchaseOrderNumber = default;
            RebillDetails rebillDetails = default;
            BillingInvoiceStatus? status = default;
            string subscriptionDisplayName = default;
            string subscriptionId = default;
            SpecialTaxationType? specialTaxationType = default;
            BillingAmount subTotal = default;
            BillingAmount taxAmount = default;
            BillingAmount totalAmount = default;
            RefundDetailsSummary refundDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("amountDue"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    amountDue = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("azurePrepaymentApplied"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    azurePrepaymentApplied = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("billedAmount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    billedAmount = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("billedDocumentId"u8))
                {
                    billedDocumentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("billingProfileDisplayName"u8))
                {
                    billingProfileDisplayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("billingProfileId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    billingProfileId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("creditAmount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    creditAmount = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("creditForDocumentId"u8))
                {
                    creditForDocumentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("documents"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InvoiceDocument> array = new List<InvoiceDocument>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InvoiceDocument.DeserializeInvoiceDocument(item, options));
                    }
                    documents = array;
                    continue;
                }
                if (property.NameEquals("documentType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    documentType = new InvoiceDocumentType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dueDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dueDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("failedPayments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BillingInvoiceFailedPayment> array = new List<BillingInvoiceFailedPayment>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BillingInvoiceFailedPayment.DeserializeBillingInvoiceFailedPayment(item, options));
                    }
                    failedPayments = array;
                    continue;
                }
                if (property.NameEquals("freeAzureCreditApplied"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    freeAzureCreditApplied = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("invoiceDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invoiceDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("invoicePeriodEndDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invoicePeriodEndDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("invoicePeriodStartDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invoicePeriodStartDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("invoiceType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invoiceType = new BillingInvoiceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isMonthlyInvoice"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isMonthlyInvoice = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("payments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BillingInvoicePayment> array = new List<BillingInvoicePayment>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BillingInvoicePayment.DeserializeBillingInvoicePayment(item, options));
                    }
                    payments = array;
                    continue;
                }
                if (property.NameEquals("purchaseOrderNumber"u8))
                {
                    purchaseOrderNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("rebillDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rebillDetails = RebillDetails.DeserializeRebillDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = new BillingInvoiceStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("subscriptionDisplayName"u8))
                {
                    subscriptionDisplayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subscriptionId"u8))
                {
                    subscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("specialTaxationType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    specialTaxationType = new SpecialTaxationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("subTotal"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    subTotal = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("taxAmount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    taxAmount = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("totalAmount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalAmount = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("refundDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    refundDetails = RefundDetailsSummary.DeserializeRefundDetailsSummary(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BillingInvoiceProperties(
                amountDue,
                azurePrepaymentApplied,
                billedAmount,
                billedDocumentId,
                billingProfileDisplayName,
                billingProfileId,
                creditAmount,
                creditForDocumentId,
                documents ?? new ChangeTrackingList<InvoiceDocument>(),
                documentType,
                dueDate,
                failedPayments ?? new ChangeTrackingList<BillingInvoiceFailedPayment>(),
                freeAzureCreditApplied,
                invoiceDate,
                invoicePeriodEndDate,
                invoicePeriodStartDate,
                invoiceType,
                isMonthlyInvoice,
                payments ?? new ChangeTrackingList<BillingInvoicePayment>(),
                purchaseOrderNumber,
                rebillDetails,
                status,
                subscriptionDisplayName,
                subscriptionId,
                specialTaxationType,
                subTotal,
                taxAmount,
                totalAmount,
                refundDetails,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AmountDue), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  amountDue: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AmountDue))
                {
                    builder.Append("  amountDue: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AmountDue, options, 2, false, "  amountDue: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AzurePrepaymentApplied), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  azurePrepaymentApplied: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AzurePrepaymentApplied))
                {
                    builder.Append("  azurePrepaymentApplied: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AzurePrepaymentApplied, options, 2, false, "  azurePrepaymentApplied: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BilledAmount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billedAmount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BilledAmount))
                {
                    builder.Append("  billedAmount: ");
                    BicepSerializationHelpers.AppendChildObject(builder, BilledAmount, options, 2, false, "  billedAmount: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BilledDocumentId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billedDocumentId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BilledDocumentId))
                {
                    builder.Append("  billedDocumentId: ");
                    if (BilledDocumentId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BilledDocumentId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BilledDocumentId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingProfileDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billingProfileDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingProfileDisplayName))
                {
                    builder.Append("  billingProfileDisplayName: ");
                    if (BillingProfileDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BillingProfileDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BillingProfileDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingProfileId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billingProfileId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingProfileId))
                {
                    builder.Append("  billingProfileId: ");
                    builder.AppendLine($"'{BillingProfileId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreditAmount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  creditAmount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreditAmount))
                {
                    builder.Append("  creditAmount: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CreditAmount, options, 2, false, "  creditAmount: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreditForDocumentId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  creditForDocumentId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreditForDocumentId))
                {
                    builder.Append("  creditForDocumentId: ");
                    if (CreditForDocumentId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CreditForDocumentId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CreditForDocumentId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Documents), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  documents: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Documents))
                {
                    if (Documents.Any())
                    {
                        builder.Append("  documents: ");
                        builder.AppendLine("[");
                        foreach (var item in Documents)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  documents: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DocumentType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  documentType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DocumentType))
                {
                    builder.Append("  documentType: ");
                    builder.AppendLine($"'{DocumentType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DueOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dueDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DueOn))
                {
                    builder.Append("  dueDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(DueOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FailedPayments), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  failedPayments: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(FailedPayments))
                {
                    if (FailedPayments.Any())
                    {
                        builder.Append("  failedPayments: ");
                        builder.AppendLine("[");
                        foreach (var item in FailedPayments)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  failedPayments: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FreeAzureCreditApplied), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  freeAzureCreditApplied: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FreeAzureCreditApplied))
                {
                    builder.Append("  freeAzureCreditApplied: ");
                    BicepSerializationHelpers.AppendChildObject(builder, FreeAzureCreditApplied, options, 2, false, "  freeAzureCreditApplied: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoiceDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoiceOn))
                {
                    builder.Append("  invoiceDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(InvoiceOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoicePeriodEndOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoicePeriodEndDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoicePeriodEndOn))
                {
                    builder.Append("  invoicePeriodEndDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(InvoicePeriodEndOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoicePeriodStartOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoicePeriodStartDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoicePeriodStartOn))
                {
                    builder.Append("  invoicePeriodStartDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(InvoicePeriodStartOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoiceType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoiceType))
                {
                    builder.Append("  invoiceType: ");
                    builder.AppendLine($"'{InvoiceType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsMonthlyInvoice), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isMonthlyInvoice: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsMonthlyInvoice))
                {
                    builder.Append("  isMonthlyInvoice: ");
                    var boolValue = IsMonthlyInvoice.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Payments), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  payments: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Payments))
                {
                    if (Payments.Any())
                    {
                        builder.Append("  payments: ");
                        builder.AppendLine("[");
                        foreach (var item in Payments)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  payments: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PurchaseOrderNumber), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  purchaseOrderNumber: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PurchaseOrderNumber))
                {
                    builder.Append("  purchaseOrderNumber: ");
                    if (PurchaseOrderNumber.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PurchaseOrderNumber}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PurchaseOrderNumber}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RebillDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  rebillDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RebillDetails))
                {
                    builder.Append("  rebillDetails: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RebillDetails, options, 2, false, "  rebillDetails: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("  status: ");
                    builder.AppendLine($"'{Status.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubscriptionDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  subscriptionDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubscriptionDisplayName))
                {
                    builder.Append("  subscriptionDisplayName: ");
                    if (SubscriptionDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SubscriptionDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SubscriptionDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubscriptionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  subscriptionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubscriptionId))
                {
                    builder.Append("  subscriptionId: ");
                    if (SubscriptionId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SubscriptionId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SubscriptionId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SpecialTaxationType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  specialTaxationType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SpecialTaxationType))
                {
                    builder.Append("  specialTaxationType: ");
                    builder.AppendLine($"'{SpecialTaxationType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubTotal), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  subTotal: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubTotal))
                {
                    builder.Append("  subTotal: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SubTotal, options, 2, false, "  subTotal: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TaxAmount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  taxAmount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TaxAmount))
                {
                    builder.Append("  taxAmount: ");
                    BicepSerializationHelpers.AppendChildObject(builder, TaxAmount, options, 2, false, "  taxAmount: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TotalAmount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  totalAmount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TotalAmount))
                {
                    builder.Append("  totalAmount: ");
                    BicepSerializationHelpers.AppendChildObject(builder, TotalAmount, options, 2, false, "  totalAmount: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RefundDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  refundDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RefundDetails))
                {
                    builder.Append("  refundDetails: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RefundDetails, options, 2, false, "  refundDetails: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<BillingInvoiceProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingInvoiceProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(BillingInvoiceProperties)} does not support writing '{options.Format}' format.");
            }
        }

        BillingInvoiceProperties IPersistableModel<BillingInvoiceProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingInvoiceProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBillingInvoiceProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BillingInvoiceProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BillingInvoiceProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
