// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The reason that the payment failed. </summary>
    public readonly partial struct BillingInvoiceFailedPaymentReason : IEquatable<BillingInvoiceFailedPaymentReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingInvoiceFailedPaymentReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingInvoiceFailedPaymentReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string BankDeclinedValue = "BankDeclined";
        private const string CardExpiredValue = "CardExpired";
        private const string IncorrectCardDetailsValue = "IncorrectCardDetails";

        /// <summary> Other. </summary>
        public static BillingInvoiceFailedPaymentReason Other { get; } = new BillingInvoiceFailedPaymentReason(OtherValue);
        /// <summary> BankDeclined. </summary>
        public static BillingInvoiceFailedPaymentReason BankDeclined { get; } = new BillingInvoiceFailedPaymentReason(BankDeclinedValue);
        /// <summary> CardExpired. </summary>
        public static BillingInvoiceFailedPaymentReason CardExpired { get; } = new BillingInvoiceFailedPaymentReason(CardExpiredValue);
        /// <summary> IncorrectCardDetails. </summary>
        public static BillingInvoiceFailedPaymentReason IncorrectCardDetails { get; } = new BillingInvoiceFailedPaymentReason(IncorrectCardDetailsValue);
        /// <summary> Determines if two <see cref="BillingInvoiceFailedPaymentReason"/> values are the same. </summary>
        public static bool operator ==(BillingInvoiceFailedPaymentReason left, BillingInvoiceFailedPaymentReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingInvoiceFailedPaymentReason"/> values are not the same. </summary>
        public static bool operator !=(BillingInvoiceFailedPaymentReason left, BillingInvoiceFailedPaymentReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingInvoiceFailedPaymentReason"/>. </summary>
        public static implicit operator BillingInvoiceFailedPaymentReason(string value) => new BillingInvoiceFailedPaymentReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingInvoiceFailedPaymentReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingInvoiceFailedPaymentReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
