// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> A failed payment. </summary>
    public partial class BillingInvoiceFailedPayment
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingInvoiceFailedPayment"/>. </summary>
        internal BillingInvoiceFailedPayment()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingInvoiceFailedPayment"/>. </summary>
        /// <param name="on"> The date when the payment was attempted. </param>
        /// <param name="failedPaymentReason"> The reason that the payment failed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingInvoiceFailedPayment(DateTimeOffset? @on, BillingInvoiceFailedPaymentReason? failedPaymentReason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            On = @on;
            FailedPaymentReason = failedPaymentReason;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The date when the payment was attempted. </summary>
        [WirePath("date")]
        public DateTimeOffset? On { get; }
        /// <summary> The reason that the payment failed. </summary>
        [WirePath("failedPaymentReason")]
        public BillingInvoiceFailedPaymentReason? FailedPaymentReason { get; }
    }
}
