// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The support level offer associated with an enrollment. </summary>
    public readonly partial struct BillingEnrollmentSupportLevel : IEquatable<BillingEnrollmentSupportLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingEnrollmentSupportLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingEnrollmentSupportLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string StandardValue = "Standard";
        private const string ProDirectValue = "Pro-Direct";
        private const string DeveloperValue = "Developer";

        /// <summary> Other. </summary>
        public static BillingEnrollmentSupportLevel Other { get; } = new BillingEnrollmentSupportLevel(OtherValue);
        /// <summary> Standard. </summary>
        public static BillingEnrollmentSupportLevel Standard { get; } = new BillingEnrollmentSupportLevel(StandardValue);
        /// <summary> Pro-Direct. </summary>
        public static BillingEnrollmentSupportLevel ProDirect { get; } = new BillingEnrollmentSupportLevel(ProDirectValue);
        /// <summary> Developer. </summary>
        public static BillingEnrollmentSupportLevel Developer { get; } = new BillingEnrollmentSupportLevel(DeveloperValue);
        /// <summary> Determines if two <see cref="BillingEnrollmentSupportLevel"/> values are the same. </summary>
        public static bool operator ==(BillingEnrollmentSupportLevel left, BillingEnrollmentSupportLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingEnrollmentSupportLevel"/> values are not the same. </summary>
        public static bool operator !=(BillingEnrollmentSupportLevel left, BillingEnrollmentSupportLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingEnrollmentSupportLevel"/>. </summary>
        public static implicit operator BillingEnrollmentSupportLevel(string value) => new BillingEnrollmentSupportLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingEnrollmentSupportLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingEnrollmentSupportLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
