// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The source of the document. ENF for Brazil and DRS for rest of the world. </summary>
    public readonly partial struct BillingDocumentSource : IEquatable<BillingDocumentSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingDocumentSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingDocumentSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string DrsValue = "DRS";
        private const string EnfValue = "ENF";

        /// <summary> Other. </summary>
        public static BillingDocumentSource Other { get; } = new BillingDocumentSource(OtherValue);
        /// <summary> DRS. </summary>
        public static BillingDocumentSource Drs { get; } = new BillingDocumentSource(DrsValue);
        /// <summary> ENF. </summary>
        public static BillingDocumentSource Enf { get; } = new BillingDocumentSource(EnfValue);
        /// <summary> Determines if two <see cref="BillingDocumentSource"/> values are the same. </summary>
        public static bool operator ==(BillingDocumentSource left, BillingDocumentSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingDocumentSource"/> values are not the same. </summary>
        public static bool operator !=(BillingDocumentSource left, BillingDocumentSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingDocumentSource"/>. </summary>
        public static implicit operator BillingDocumentSource(string value) => new BillingDocumentSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingDocumentSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingDocumentSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
