// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Identifies the status of an customer. This is an upcoming property that will be populated in the future. </summary>
    public readonly partial struct BillingCustomerStatus : IEquatable<BillingCustomerStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingCustomerStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingCustomerStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string ActiveValue = "Active";
        private const string PendingValue = "Pending";
        private const string DisabledValue = "Disabled";
        private const string WarnedValue = "Warned";
        private const string DeletedValue = "Deleted";
        private const string UnderReviewValue = "UnderReview";

        /// <summary> Other. </summary>
        public static BillingCustomerStatus Other { get; } = new BillingCustomerStatus(OtherValue);
        /// <summary> Active. </summary>
        public static BillingCustomerStatus Active { get; } = new BillingCustomerStatus(ActiveValue);
        /// <summary> Pending. </summary>
        public static BillingCustomerStatus Pending { get; } = new BillingCustomerStatus(PendingValue);
        /// <summary> Disabled. </summary>
        public static BillingCustomerStatus Disabled { get; } = new BillingCustomerStatus(DisabledValue);
        /// <summary> Warned. </summary>
        public static BillingCustomerStatus Warned { get; } = new BillingCustomerStatus(WarnedValue);
        /// <summary> Deleted. </summary>
        public static BillingCustomerStatus Deleted { get; } = new BillingCustomerStatus(DeletedValue);
        /// <summary> UnderReview. </summary>
        public static BillingCustomerStatus UnderReview { get; } = new BillingCustomerStatus(UnderReviewValue);
        /// <summary> Determines if two <see cref="BillingCustomerStatus"/> values are the same. </summary>
        public static bool operator ==(BillingCustomerStatus left, BillingCustomerStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingCustomerStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingCustomerStatus left, BillingCustomerStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingCustomerStatus"/>. </summary>
        public static implicit operator BillingCustomerStatus(string value) => new BillingCustomerStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingCustomerStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingCustomerStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
