// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The properties of a check access response. </summary>
    public partial class BillingCheckAccessResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingCheckAccessResult"/>. </summary>
        internal BillingCheckAccessResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingCheckAccessResult"/>. </summary>
        /// <param name="accessDecision"> Access Decision, specifies access is allowed or not. </param>
        /// <param name="action"> Gets or sets an action. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingCheckAccessResult(BillingProfileAccessDecision? accessDecision, string action, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AccessDecision = accessDecision;
            Action = action;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Access Decision, specifies access is allowed or not. </summary>
        [WirePath("accessDecision")]
        public BillingProfileAccessDecision? AccessDecision { get; }
        /// <summary> Gets or sets an action. </summary>
        [WirePath("action")]
        public string Action { get; }
    }
}
