// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Commitment grain. </summary>
    public readonly partial struct BillingBenefitCommitmentGrain : IEquatable<BillingBenefitCommitmentGrain>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingBenefitCommitmentGrain"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingBenefitCommitmentGrain(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HourlyValue = "Hourly";

        /// <summary> Hourly. </summary>
        public static BillingBenefitCommitmentGrain Hourly { get; } = new BillingBenefitCommitmentGrain(HourlyValue);
        /// <summary> Determines if two <see cref="BillingBenefitCommitmentGrain"/> values are the same. </summary>
        public static bool operator ==(BillingBenefitCommitmentGrain left, BillingBenefitCommitmentGrain right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingBenefitCommitmentGrain"/> values are not the same. </summary>
        public static bool operator !=(BillingBenefitCommitmentGrain left, BillingBenefitCommitmentGrain right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingBenefitCommitmentGrain"/>. </summary>
        public static implicit operator BillingBenefitCommitmentGrain(string value) => new BillingBenefitCommitmentGrain(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingBenefitCommitmentGrain other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingBenefitCommitmentGrain other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
