// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class BillingAvailableBalanceProperties : IUtf8JsonSerializable, IJsonModel<BillingAvailableBalanceProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BillingAvailableBalanceProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BillingAvailableBalanceProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingAvailableBalanceProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingAvailableBalanceProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Amount))
            {
                writer.WritePropertyName("amount"u8);
                writer.WriteObjectValue(Amount, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PaymentsOnAccount))
            {
                writer.WritePropertyName("paymentsOnAccount"u8);
                writer.WriteStartArray();
                foreach (var item in PaymentsOnAccount)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(TotalPaymentsOnAccount))
            {
                writer.WritePropertyName("totalPaymentsOnAccount"u8);
                writer.WriteObjectValue(TotalPaymentsOnAccount, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BillingAvailableBalanceProperties IJsonModel<BillingAvailableBalanceProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingAvailableBalanceProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingAvailableBalanceProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBillingAvailableBalanceProperties(document.RootElement, options);
        }

        internal static BillingAvailableBalanceProperties DeserializeBillingAvailableBalanceProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BillingAmount amount = default;
            IReadOnlyList<BillingPaymentOnAccount> paymentsOnAccount = default;
            BillingAmount totalPaymentsOnAccount = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("amount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    amount = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("paymentsOnAccount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BillingPaymentOnAccount> array = new List<BillingPaymentOnAccount>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BillingPaymentOnAccount.DeserializeBillingPaymentOnAccount(item, options));
                    }
                    paymentsOnAccount = array;
                    continue;
                }
                if (property.NameEquals("totalPaymentsOnAccount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalPaymentsOnAccount = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BillingAvailableBalanceProperties(amount, paymentsOnAccount ?? new ChangeTrackingList<BillingPaymentOnAccount>(), totalPaymentsOnAccount, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Amount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  amount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Amount))
                {
                    builder.Append("  amount: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Amount, options, 2, false, "  amount: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PaymentsOnAccount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  paymentsOnAccount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PaymentsOnAccount))
                {
                    if (PaymentsOnAccount.Any())
                    {
                        builder.Append("  paymentsOnAccount: ");
                        builder.AppendLine("[");
                        foreach (var item in PaymentsOnAccount)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  paymentsOnAccount: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TotalPaymentsOnAccount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  totalPaymentsOnAccount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TotalPaymentsOnAccount))
                {
                    builder.Append("  totalPaymentsOnAccount: ");
                    BicepSerializationHelpers.AppendChildObject(builder, TotalPaymentsOnAccount, options, 2, false, "  totalPaymentsOnAccount: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<BillingAvailableBalanceProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingAvailableBalanceProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(BillingAvailableBalanceProperties)} does not support writing '{options.Format}' format.");
            }
        }

        BillingAvailableBalanceProperties IPersistableModel<BillingAvailableBalanceProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingAvailableBalanceProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBillingAvailableBalanceProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BillingAvailableBalanceProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BillingAvailableBalanceProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
