// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> An associated tenant. </summary>
    public partial class BillingAssociatedTenantProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingAssociatedTenantProperties"/>. </summary>
        public BillingAssociatedTenantProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingAssociatedTenantProperties"/>. </summary>
        /// <param name="provisioningState"> The provisioning state of the resource during a long-running operation. </param>
        /// <param name="displayName"> The name of the associated tenant. </param>
        /// <param name="tenantId"> The ID that uniquely identifies a tenant. </param>
        /// <param name="billingManagementState"> The state determines whether users from the associated tenant can be assigned roles for commerce activities like viewing and downloading invoices, managing payments, and making purchases. </param>
        /// <param name="provisioningManagementState"> The state determines whether subscriptions and licenses can be provisioned in the associated tenant. It can be set to 'Pending' to initiate a billing request. </param>
        /// <param name="provisioningBillingRequestId"> The unique identifier for the billing request that is created when enabling provisioning for an associated tenant. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingAssociatedTenantProperties(BillingProvisioningState? provisioningState, string displayName, Guid? tenantId, BillingManagementTenantState? billingManagementState, BillingProvisioningTenantState? provisioningManagementState, string provisioningBillingRequestId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            DisplayName = displayName;
            TenantId = tenantId;
            BillingManagementState = billingManagementState;
            ProvisioningManagementState = provisioningManagementState;
            ProvisioningBillingRequestId = provisioningBillingRequestId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The provisioning state of the resource during a long-running operation. </summary>
        [WirePath("provisioningState")]
        public BillingProvisioningState? ProvisioningState { get; }
        /// <summary> The name of the associated tenant. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; set; }
        /// <summary> The ID that uniquely identifies a tenant. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; set; }
        /// <summary> The state determines whether users from the associated tenant can be assigned roles for commerce activities like viewing and downloading invoices, managing payments, and making purchases. </summary>
        [WirePath("billingManagementState")]
        public BillingManagementTenantState? BillingManagementState { get; set; }
        /// <summary> The state determines whether subscriptions and licenses can be provisioned in the associated tenant. It can be set to 'Pending' to initiate a billing request. </summary>
        [WirePath("provisioningManagementState")]
        public BillingProvisioningTenantState? ProvisioningManagementState { get; set; }
        /// <summary> The unique identifier for the billing request that is created when enabling provisioning for an associated tenant. </summary>
        [WirePath("provisioningBillingRequestId")]
        public string ProvisioningBillingRequestId { get; }
    }
}
