// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The type of agreement. </summary>
    public readonly partial struct BillingAgreementType : IEquatable<BillingAgreementType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingAgreementType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingAgreementType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string MicrosoftCustomerAgreementValue = "MicrosoftCustomerAgreement";
        private const string EnterpriseAgreementValue = "EnterpriseAgreement";
        private const string MicrosoftOnlineServicesProgramValue = "MicrosoftOnlineServicesProgram";
        private const string MicrosoftPartnerAgreementValue = "MicrosoftPartnerAgreement";

        /// <summary> Other. </summary>
        public static BillingAgreementType Other { get; } = new BillingAgreementType(OtherValue);
        /// <summary> MicrosoftCustomerAgreement. </summary>
        public static BillingAgreementType MicrosoftCustomerAgreement { get; } = new BillingAgreementType(MicrosoftCustomerAgreementValue);
        /// <summary> EnterpriseAgreement. </summary>
        public static BillingAgreementType EnterpriseAgreement { get; } = new BillingAgreementType(EnterpriseAgreementValue);
        /// <summary> MicrosoftOnlineServicesProgram. </summary>
        public static BillingAgreementType MicrosoftOnlineServicesProgram { get; } = new BillingAgreementType(MicrosoftOnlineServicesProgramValue);
        /// <summary> MicrosoftPartnerAgreement. </summary>
        public static BillingAgreementType MicrosoftPartnerAgreement { get; } = new BillingAgreementType(MicrosoftPartnerAgreementValue);
        /// <summary> Determines if two <see cref="BillingAgreementType"/> values are the same. </summary>
        public static bool operator ==(BillingAgreementType left, BillingAgreementType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingAgreementType"/> values are not the same. </summary>
        public static bool operator !=(BillingAgreementType left, BillingAgreementType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingAgreementType"/>. </summary>
        public static implicit operator BillingAgreementType(string value) => new BillingAgreementType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingAgreementType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingAgreementType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
