// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Billing account name. Available for a specific type of agreement. </summary>
    public partial class BillingAgreementParticipant
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingAgreementParticipant"/>. </summary>
        internal BillingAgreementParticipant()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingAgreementParticipant"/>. </summary>
        /// <param name="email"> The email address of the participant. </param>
        /// <param name="status"> The acceptance status of the participant. </param>
        /// <param name="statusOn"> The date when the status got changed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingAgreementParticipant(string email, string status, DateTimeOffset? statusOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Email = email;
            Status = status;
            StatusOn = statusOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The email address of the participant. </summary>
        [WirePath("email")]
        public string Email { get; }
        /// <summary> The acceptance status of the participant. </summary>
        [WirePath("status")]
        public string Status { get; }
        /// <summary> The date when the status got changed. </summary>
        [WirePath("statusDate")]
        public DateTimeOffset? StatusOn { get; }
    }
}
