// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The category of the agreement. </summary>
    public readonly partial struct BillingAgreementCategory : IEquatable<BillingAgreementCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingAgreementCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingAgreementCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AffiliatePurchaseTermsValue = "AffiliatePurchaseTerms";
        private const string IndirectForGovernmentAgreementValue = "IndirectForGovernmentAgreement";
        private const string MicrosoftCustomerAgreementValue = "MicrosoftCustomerAgreement";
        private const string MicrosoftPartnerAgreementValue = "MicrosoftPartnerAgreement";
        private const string UKCloudComputeFrameworkValue = "UKCloudComputeFramework";

        /// <summary> Other. </summary>
        public static BillingAgreementCategory Other { get; } = new BillingAgreementCategory(OtherValue);
        /// <summary> AffiliatePurchaseTerms. </summary>
        public static BillingAgreementCategory AffiliatePurchaseTerms { get; } = new BillingAgreementCategory(AffiliatePurchaseTermsValue);
        /// <summary> IndirectForGovernmentAgreement. </summary>
        public static BillingAgreementCategory IndirectForGovernmentAgreement { get; } = new BillingAgreementCategory(IndirectForGovernmentAgreementValue);
        /// <summary> MicrosoftCustomerAgreement. </summary>
        public static BillingAgreementCategory MicrosoftCustomerAgreement { get; } = new BillingAgreementCategory(MicrosoftCustomerAgreementValue);
        /// <summary> MicrosoftPartnerAgreement. </summary>
        public static BillingAgreementCategory MicrosoftPartnerAgreement { get; } = new BillingAgreementCategory(MicrosoftPartnerAgreementValue);
        /// <summary> UKCloudComputeFramework. </summary>
        public static BillingAgreementCategory UKCloudComputeFramework { get; } = new BillingAgreementCategory(UKCloudComputeFrameworkValue);
        /// <summary> Determines if two <see cref="BillingAgreementCategory"/> values are the same. </summary>
        public static bool operator ==(BillingAgreementCategory left, BillingAgreementCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingAgreementCategory"/> values are not the same. </summary>
        public static bool operator !=(BillingAgreementCategory left, BillingAgreementCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingAgreementCategory"/>. </summary>
        public static implicit operator BillingAgreementCategory(string value) => new BillingAgreementCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingAgreementCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingAgreementCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
