// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Status of the address validation. </summary>
    public readonly partial struct BillingAddressValidationStatus : IEquatable<BillingAddressValidationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingAddressValidationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingAddressValidationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string ValidValue = "Valid";
        private const string InvalidValue = "Invalid";

        /// <summary> Other. </summary>
        public static BillingAddressValidationStatus Other { get; } = new BillingAddressValidationStatus(OtherValue);
        /// <summary> Valid. </summary>
        public static BillingAddressValidationStatus Valid { get; } = new BillingAddressValidationStatus(ValidValue);
        /// <summary> Invalid. </summary>
        public static BillingAddressValidationStatus Invalid { get; } = new BillingAddressValidationStatus(InvalidValue);
        /// <summary> Determines if two <see cref="BillingAddressValidationStatus"/> values are the same. </summary>
        public static bool operator ==(BillingAddressValidationStatus left, BillingAddressValidationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingAddressValidationStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingAddressValidationStatus left, BillingAddressValidationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingAddressValidationStatus"/>. </summary>
        public static implicit operator BillingAddressValidationStatus(string value) => new BillingAddressValidationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingAddressValidationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingAddressValidationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
