// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class BillingAddressDetails : IUtf8JsonSerializable, IJsonModel<BillingAddressDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BillingAddressDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BillingAddressDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingAddressDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingAddressDetails)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("addressLine1"u8);
            writer.WriteStringValue(AddressLine1);
            if (Optional.IsDefined(AddressLine2))
            {
                writer.WritePropertyName("addressLine2"u8);
                writer.WriteStringValue(AddressLine2);
            }
            if (Optional.IsDefined(AddressLine3))
            {
                writer.WritePropertyName("addressLine3"u8);
                writer.WriteStringValue(AddressLine3);
            }
            if (Optional.IsDefined(City))
            {
                writer.WritePropertyName("city"u8);
                writer.WriteStringValue(City);
            }
            if (Optional.IsDefined(CompanyName))
            {
                writer.WritePropertyName("companyName"u8);
                writer.WriteStringValue(CompanyName);
            }
            writer.WritePropertyName("country"u8);
            writer.WriteStringValue(Country);
            if (Optional.IsDefined(District))
            {
                writer.WritePropertyName("district"u8);
                writer.WriteStringValue(District);
            }
            if (Optional.IsDefined(Email))
            {
                writer.WritePropertyName("email"u8);
                writer.WriteStringValue(Email);
            }
            if (Optional.IsDefined(FirstName))
            {
                writer.WritePropertyName("firstName"u8);
                writer.WriteStringValue(FirstName);
            }
            if (Optional.IsDefined(LastName))
            {
                writer.WritePropertyName("lastName"u8);
                writer.WriteStringValue(LastName);
            }
            if (Optional.IsDefined(MiddleName))
            {
                writer.WritePropertyName("middleName"u8);
                writer.WriteStringValue(MiddleName);
            }
            if (Optional.IsDefined(PhoneNumber))
            {
                writer.WritePropertyName("phoneNumber"u8);
                writer.WriteStringValue(PhoneNumber);
            }
            if (Optional.IsDefined(PostalCode))
            {
                writer.WritePropertyName("postalCode"u8);
                writer.WriteStringValue(PostalCode);
            }
            if (Optional.IsDefined(Region))
            {
                writer.WritePropertyName("region"u8);
                writer.WriteStringValue(Region);
            }
            if (Optional.IsDefined(IsValidAddress))
            {
                writer.WritePropertyName("isValidAddress"u8);
                writer.WriteBooleanValue(IsValidAddress.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BillingAddressDetails IJsonModel<BillingAddressDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingAddressDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BillingAddressDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBillingAddressDetails(document.RootElement, options);
        }

        internal static BillingAddressDetails DeserializeBillingAddressDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string addressLine1 = default;
            string addressLine2 = default;
            string addressLine3 = default;
            string city = default;
            string companyName = default;
            string country = default;
            string district = default;
            string email = default;
            string firstName = default;
            string lastName = default;
            string middleName = default;
            string phoneNumber = default;
            string postalCode = default;
            string region = default;
            bool? isValidAddress = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("addressLine1"u8))
                {
                    addressLine1 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("addressLine2"u8))
                {
                    addressLine2 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("addressLine3"u8))
                {
                    addressLine3 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("city"u8))
                {
                    city = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("companyName"u8))
                {
                    companyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("country"u8))
                {
                    country = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("district"u8))
                {
                    district = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("email"u8))
                {
                    email = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firstName"u8))
                {
                    firstName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastName"u8))
                {
                    lastName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("middleName"u8))
                {
                    middleName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("phoneNumber"u8))
                {
                    phoneNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("postalCode"u8))
                {
                    postalCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("region"u8))
                {
                    region = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isValidAddress"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isValidAddress = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BillingAddressDetails(
                addressLine1,
                addressLine2,
                addressLine3,
                city,
                companyName,
                country,
                district,
                email,
                firstName,
                lastName,
                middleName,
                phoneNumber,
                postalCode,
                region,
                isValidAddress,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AddressLine1), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  addressLine1: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AddressLine1))
                {
                    builder.Append("  addressLine1: ");
                    if (AddressLine1.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AddressLine1}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AddressLine1}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AddressLine2), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  addressLine2: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AddressLine2))
                {
                    builder.Append("  addressLine2: ");
                    if (AddressLine2.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AddressLine2}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AddressLine2}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AddressLine3), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  addressLine3: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AddressLine3))
                {
                    builder.Append("  addressLine3: ");
                    if (AddressLine3.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AddressLine3}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AddressLine3}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(City), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  city: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(City))
                {
                    builder.Append("  city: ");
                    if (City.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{City}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{City}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CompanyName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  companyName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CompanyName))
                {
                    builder.Append("  companyName: ");
                    if (CompanyName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CompanyName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CompanyName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Country), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  country: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Country))
                {
                    builder.Append("  country: ");
                    if (Country.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Country}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Country}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(District), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  district: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(District))
                {
                    builder.Append("  district: ");
                    if (District.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{District}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{District}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Email), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  email: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Email))
                {
                    builder.Append("  email: ");
                    if (Email.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Email}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Email}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FirstName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  firstName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FirstName))
                {
                    builder.Append("  firstName: ");
                    if (FirstName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{FirstName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{FirstName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  lastName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastName))
                {
                    builder.Append("  lastName: ");
                    if (LastName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LastName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LastName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MiddleName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  middleName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MiddleName))
                {
                    builder.Append("  middleName: ");
                    if (MiddleName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MiddleName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MiddleName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PhoneNumber), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  phoneNumber: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PhoneNumber))
                {
                    builder.Append("  phoneNumber: ");
                    if (PhoneNumber.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PhoneNumber}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PhoneNumber}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PostalCode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  postalCode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PostalCode))
                {
                    builder.Append("  postalCode: ");
                    if (PostalCode.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PostalCode}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PostalCode}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Region), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  region: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Region))
                {
                    builder.Append("  region: ");
                    if (Region.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Region}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Region}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsValidAddress), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isValidAddress: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsValidAddress))
                {
                    builder.Append("  isValidAddress: ");
                    var boolValue = IsValidAddress.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<BillingAddressDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingAddressDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(BillingAddressDetails)} does not support writing '{options.Format}' format.");
            }
        }

        BillingAddressDetails IPersistableModel<BillingAddressDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BillingAddressDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBillingAddressDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BillingAddressDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BillingAddressDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
