// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The tier of the account. </summary>
    public readonly partial struct BillingAccountSubType : IEquatable<BillingAccountSubType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingAccountSubType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingAccountSubType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string NoneValue = "None";
        private const string IndividualValue = "Individual";
        private const string ProfessionalValue = "Professional";
        private const string EnterpriseValue = "Enterprise";

        /// <summary> Other. </summary>
        public static BillingAccountSubType Other { get; } = new BillingAccountSubType(OtherValue);
        /// <summary> None. </summary>
        public static BillingAccountSubType None { get; } = new BillingAccountSubType(NoneValue);
        /// <summary> Individual. </summary>
        public static BillingAccountSubType Individual { get; } = new BillingAccountSubType(IndividualValue);
        /// <summary> Professional. </summary>
        public static BillingAccountSubType Professional { get; } = new BillingAccountSubType(ProfessionalValue);
        /// <summary> Enterprise. </summary>
        public static BillingAccountSubType Enterprise { get; } = new BillingAccountSubType(EnterpriseValue);
        /// <summary> Determines if two <see cref="BillingAccountSubType"/> values are the same. </summary>
        public static bool operator ==(BillingAccountSubType left, BillingAccountSubType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingAccountSubType"/> values are not the same. </summary>
        public static bool operator !=(BillingAccountSubType left, BillingAccountSubType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingAccountSubType"/>. </summary>
        public static implicit operator BillingAccountSubType(string value) => new BillingAccountSubType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingAccountSubType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingAccountSubType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
