// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Reason for the specified billing account status. </summary>
    public readonly partial struct BillingAccountStatusReasonCode : IEquatable<BillingAccountStatusReasonCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingAccountStatusReasonCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingAccountStatusReasonCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string UnusualActivityValue = "UnusualActivity";
        private const string ManuallyTerminatedValue = "ManuallyTerminated";
        private const string ExpiredValue = "Expired";
        private const string TransferredValue = "Transferred";
        private const string TerminateProcessingValue = "TerminateProcessing";

        /// <summary> Other. </summary>
        public static BillingAccountStatusReasonCode Other { get; } = new BillingAccountStatusReasonCode(OtherValue);
        /// <summary> UnusualActivity. </summary>
        public static BillingAccountStatusReasonCode UnusualActivity { get; } = new BillingAccountStatusReasonCode(UnusualActivityValue);
        /// <summary> ManuallyTerminated. </summary>
        public static BillingAccountStatusReasonCode ManuallyTerminated { get; } = new BillingAccountStatusReasonCode(ManuallyTerminatedValue);
        /// <summary> Expired. </summary>
        public static BillingAccountStatusReasonCode Expired { get; } = new BillingAccountStatusReasonCode(ExpiredValue);
        /// <summary> Transferred. </summary>
        public static BillingAccountStatusReasonCode Transferred { get; } = new BillingAccountStatusReasonCode(TransferredValue);
        /// <summary> TerminateProcessing. </summary>
        public static BillingAccountStatusReasonCode TerminateProcessing { get; } = new BillingAccountStatusReasonCode(TerminateProcessingValue);
        /// <summary> Determines if two <see cref="BillingAccountStatusReasonCode"/> values are the same. </summary>
        public static bool operator ==(BillingAccountStatusReasonCode left, BillingAccountStatusReasonCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingAccountStatusReasonCode"/> values are not the same. </summary>
        public static bool operator !=(BillingAccountStatusReasonCode left, BillingAccountStatusReasonCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingAccountStatusReasonCode"/>. </summary>
        public static implicit operator BillingAccountStatusReasonCode(string value) => new BillingAccountStatusReasonCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingAccountStatusReasonCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingAccountStatusReasonCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
