// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The current status of the billing account. </summary>
    public readonly partial struct BillingAccountStatus : IEquatable<BillingAccountStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingAccountStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingAccountStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string ActiveValue = "Active";
        private const string UnderReviewValue = "UnderReview";
        private const string DisabledValue = "Disabled";
        private const string DeletedValue = "Deleted";
        private const string ExtendedValue = "Extended";
        private const string PendingValue = "Pending";
        private const string NewValue = "New";
        private const string ExpiredValue = "Expired";
        private const string TerminatedValue = "Terminated";
        private const string TransferredValue = "Transferred";

        /// <summary> Other. </summary>
        public static BillingAccountStatus Other { get; } = new BillingAccountStatus(OtherValue);
        /// <summary> Active. </summary>
        public static BillingAccountStatus Active { get; } = new BillingAccountStatus(ActiveValue);
        /// <summary> UnderReview. </summary>
        public static BillingAccountStatus UnderReview { get; } = new BillingAccountStatus(UnderReviewValue);
        /// <summary> Disabled. </summary>
        public static BillingAccountStatus Disabled { get; } = new BillingAccountStatus(DisabledValue);
        /// <summary> Deleted. </summary>
        public static BillingAccountStatus Deleted { get; } = new BillingAccountStatus(DeletedValue);
        /// <summary> Extended. </summary>
        public static BillingAccountStatus Extended { get; } = new BillingAccountStatus(ExtendedValue);
        /// <summary> Pending. </summary>
        public static BillingAccountStatus Pending { get; } = new BillingAccountStatus(PendingValue);
        /// <summary> New. </summary>
        public static BillingAccountStatus New { get; } = new BillingAccountStatus(NewValue);
        /// <summary> Expired. </summary>
        public static BillingAccountStatus Expired { get; } = new BillingAccountStatus(ExpiredValue);
        /// <summary> Terminated. </summary>
        public static BillingAccountStatus Terminated { get; } = new BillingAccountStatus(TerminatedValue);
        /// <summary> Transferred. </summary>
        public static BillingAccountStatus Transferred { get; } = new BillingAccountStatus(TransferredValue);
        /// <summary> Determines if two <see cref="BillingAccountStatus"/> values are the same. </summary>
        public static bool operator ==(BillingAccountStatus left, BillingAccountStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingAccountStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingAccountStatus left, BillingAccountStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingAccountStatus"/>. </summary>
        public static implicit operator BillingAccountStatus(string value) => new BillingAccountStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingAccountStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingAccountStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
